/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.thief;

import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.jevring.frequencies.v2.configuration.Configuration;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.control.curves.Exponential;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.effects.FullEffectsChain;
import net.jevring.frequencies.v2.engine.MainLoopPullingEngine;
import net.jevring.frequencies.v2.engine.MasterVolume;
import net.jevring.frequencies.v2.engine.StereoBalance;
import net.jevring.frequencies.v2.engine.Voice;
import net.jevring.frequencies.v2.envelopes.ControlledEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelopes;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.hooks.SequencerVisualizer;
import net.jevring.frequencies.v2.hooks.Visualizer;
import net.jevring.frequencies.v2.input.InputMode;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.SwitchableMonophonicAndPolyphonicInstructionInput;
import net.jevring.frequencies.v2.input.arpeggiator.Arpeggiator;
import net.jevring.frequencies.v2.input.arpeggiator.Mode;
import net.jevring.frequencies.v2.input.euclidean.EuclideanSequencer;
import net.jevring.frequencies.v2.input.midi.MidiFrequencyMapper;
import net.jevring.frequencies.v2.input.midi.MidiManager;
import net.jevring.frequencies.v2.input.monophonic.MonophonicInput;
import net.jevring.frequencies.v2.input.polyphonic.PolyphonicInput;
import net.jevring.frequencies.v2.input.sequencer.StepSequencer;
import net.jevring.frequencies.v2.input.tempo.MainLoopTempoSource;
import net.jevring.frequencies.v2.input.tempo.MidiClockTempoSource;
import net.jevring.frequencies.v2.modular.ModularVoice;
import net.jevring.frequencies.v2.modulation.SampleAndHold;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.output.Device;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.thief.ThiefUI;
import net.jevring.thief.ThiefUISequencerVisualizer;
import net.jevring.thief.ThiefUIVisualizer;

public class Thief {
    private static final int VOICES = 8;
    private static final String DEFAULT_PRESET = "/presets/long/maffigt som FAN.conf";
    private static final float SAMPLE_SIZE_IN_BITS = 16.0f;
    private static final float SAMPLE_RATE = 44100.0f;
    private static final int STEREO = 2;
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 2, true, true);
    private final KeyTimings keyTimings = new KeyTimings();
    private final Filters filters = new Filters(44100.0);
    private final Controls controls = new Controls();
    private final Envelopes envelopes = new Envelopes();
    private final ModulationMatrix modulationMatrix = new ModulationMatrix(this.controls, 8);
    private final MidiManager midiManager;
    private final MainLoopPullingEngine engine;
    private final StepSequencer stepSequencer;
    private final Arpeggiator arpeggiator;
    private final EuclideanSequencer euclideanSequencer;
    private final Configuration configuration;
    private final MainLoopTempoSource mainLoopTempoSource;
    private final MidiClockTempoSource midiClockTempoSource;

    public Thief() {
        this.createControls();
        this.createSequencerControls();
        this.createArpeggiatorControls();
        this.createEuclideanSequencerControls();
        this.midiClockTempoSource = new MidiClockTempoSource();
        this.mainLoopTempoSource = new MainLoopTempoSource(this.controls);
        File dotConfigDirectory = new File(new File(System.getProperty("user.home")), ".config/thief");
        this.midiManager = new MidiManager(this.controls, this.keyTimings, this.midiClockTempoSource, dotConfigDirectory);
        this.midiManager.initializeMidi();
        this.stepSequencer = new StepSequencer(this.midiManager.getReceiver(), this.controls, this.keyTimings);
        this.arpeggiator = new Arpeggiator(this.midiManager.getReceiver(), this.controls, this.keyTimings);
        this.euclideanSequencer = new EuclideanSequencer(this.controls, this.keyTimings);
        this.configuration = new Configuration(this.modulationMatrix, this.controls, dotConfigDirectory);
        this.configuration.load(Thief.class.getResourceAsStream(DEFAULT_PRESET));
        ControlledEnvelope volumeEnvelope = new ControlledEnvelope(this.controls, this.envelopes, "volume");
        MonophonicInput monophonicInput = new MonophonicInput(new MidiFrequencyMapper(), volumeEnvelope, this.keyTimings, this.controls);
        PolyphonicInput polyphonicInput = new PolyphonicInput(new MidiFrequencyMapper(), volumeEnvelope, this.keyTimings, 8);
        SwitchableMonophonicAndPolyphonicInstructionInput instructionInput = new SwitchableMonophonicAndPolyphonicInstructionInput(polyphonicInput, monophonicInput, this.controls, 8);
        SampleAndHold sampleAndHold = new SampleAndHold(this.controls.getControl("sample-and-hold-frequency"), this.controls.getControl("sample-and-hold-slew"), 44100.0f);
        Voice[] voices = new Voice[8];
        for (int i = 0; i < 8; ++i) {
            voices[i] = new ModularVoice(44100.0f, this.filters, this.envelopes, this.controls, sampleAndHold, this.modulationMatrix.voice(i));
        }
        this.engine = new MainLoopPullingEngine(new StereoBalance(this.controls), instructionInput, new FullEffectsChain(this.controls, 44100.0f), new MasterVolume(this.controls), 44100.0f, voices);
        this.controls.getBooleanControl("receive-midi-clock-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean value, Object source) {
                Thief.this.selectTempoSource(value);
            }
        });
    }

    public void startEngine(Device device, SequencerVisualizer sequencerVisualizer, Visualizer visualizer) throws LineUnavailableException {
        this.engine.start(device.open(), visualizer);
        this.stepSequencer.setSequencerVisualizer(sequencerVisualizer);
        this.arpeggiator.setSequencerVisualizer(sequencerVisualizer);
        this.euclideanSequencer.setSequencerVisualizer(sequencerVisualizer);
        this.mainLoopTempoSource.start();
    }

    public void stopEngine() {
        this.mainLoopTempoSource.stop();
        this.engine.stop();
    }

    private void createEuclideanSequencerControls() {
        this.controls.createControl("euclidean-sequencer-gate", 0.0, 1.0, 0.25, new Linear());
        this.controls.createControl("euclidean-sequencer-note", 0.0, 127.0, 60.0, new Linear(), true);
        this.controls.createControl("euclidean-sequencer-rotation", 0.0, 32.0, 0.0, new Linear(), true);
        this.controls.createControl("euclidean-sequencer-inner-steps", 0.0, 32.0, 6.0, new Linear(), true);
        this.controls.createControl("euclidean-sequencer-outer-steps", 0.0, 32.0, 16.0, new Linear(), true);
        this.controls.createBooleanControl("euclidean-sequencer-active", false);
    }

    private void createArpeggiatorControls() {
        this.controls.createControl("arpeggiator-octaves", 1.0, 4.0, 1.0, new Linear(), true);
        this.controls.createControl("arpeggiator-gate", 0.0, 1.0, 0.5, new Linear());
        this.controls.createBooleanControl("arpeggiator-active", false);
        this.controls.createDiscreteControl("arpeggiator-mode", Arrays.stream(Mode.values()).map(String::valueOf).collect(Collectors.toUnmodifiableList()), "UP");
    }

    private void createSequencerControls() {
        this.controls.createControl("sequencer-steps", 1.0, 16.0, 16.0, new Linear(), true);
        this.controls.createBooleanControl("sequencer-active", false);
        this.controls.createBooleanControl("sequencer-listen", false);
        for (int step = 0; step < 16; ++step) {
            this.controls.createControl("sequencer-note-" + step, 21.0, 108.0, 57.0, new Linear(), true);
            this.controls.createControl("sequencer-gate-" + step, 0.0, 1.0, 0.75, new Linear());
        }
    }

    private void createControls() {
        this.controls.createControl("primary-oscillator-pitch-bend-depth", -1.0, 1.0, 1.0, new Linear(), false);
        this.controls.createControl("secondary-oscillator-pitch-bend-depth", -1.0, 1.0, 1.0, new Linear(), false);
        this.controls.createControl("tempo", 10.0, 750.0, 138.0, new Linear(), true);
        this.controls.createControl("swing", 0.5, 0.64, 0.5, new Linear(), false);
        this.controls.createBooleanControl("receive-midi-clock-active", false);
        this.controls.createControl("rate", 2.0, 24.0, 24.0, new Linear(), true);
        this.controls.createDiscreteControl("input-mode", Arrays.stream(InputMode.values()).map(Enum::name).collect(Collectors.toUnmodifiableList()), InputMode.MONOPHONIC.name());
        this.controls.createControl("bit-crusher-downsampling", 1.0, 128.0, 1.0, new Linear(), true);
        this.controls.createControl("bit-crusher-resolution", 1.0, 16.0, 16.0, new Linear(), true);
        this.controls.createControl("primary-oscillator-unison-detune-semi-tones", 0.0, 2.0, 1.0, new Exponential());
        this.controls.createControl("primary-oscillator-unison-voices", 1.0, 16.0, 1.0, new Exponential(), true);
        this.controls.createControl("secondary-oscillator-unison-detune-semi-tones", 0.0, 2.0, 1.0, new Exponential());
        this.controls.createControl("secondary-oscillator-unison-voices", 1.0, 16.0, 1.0, new Exponential(), true);
        this.controls.createControl("sample-and-hold-frequency", 0.0, 50.0, 0.0, new Exponential());
        this.controls.createControl("sample-and-hold-slew", 0.0, 1.0, 0.0, new Exponential());
        this.controls.createControl("experimental-value", 0.0, 2.0, 0.0, new Exponential());
        this.controls.createControl("pitch-bend", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("filter-envelope-depth", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("filter-cutoff-frequency", 20.0, 20000.0, 20000.0, new Exponential());
        this.controls.createControl("q-resonance-emphasis", 0.0, 1.0, 1.0 / Math.sqrt(2.0), new Exponential());
        this.controls.createControl("lfo1-frequency", 0.0, 1300.0, 0.0, new Exponential());
        this.controls.createControl("lfo2-frequency", 0.0, 20.0, 0.0, new Exponential());
        this.controls.createControl("lfo3-frequency", 0.0, 20.0, 0.0, new Exponential());
        this.controls.createControl("lfo1-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("lfo2-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("lfo3-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("overdrive-volume", 0.0, 10.0, 1.0, new Exponential());
        this.controls.createControl("balance", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("volume-envelope-attack", 0.0, 10000.0, 125.0, new Exponential());
        this.controls.createControl("volume-envelope-decay", 0.0, 10000.0, 350.0, new Exponential());
        this.controls.createControl("volume-envelope-sustain", 0.0, 1.0, 0.6, new Linear());
        this.controls.createControl("volume-envelope-release", 0.0, 10000.0, 550.0, new Exponential());
        this.controls.createBooleanControl("volume-envelope-loop", false);
        this.controls.createControl("filter-envelope-attack", 0.0, 10000.0, 125.0, new Exponential());
        this.controls.createControl("filter-envelope-decay", 0.0, 10000.0, 350.0, new Exponential());
        this.controls.createControl("filter-envelope-sustain", 0.0, 1.0, 0.6, new Linear());
        this.controls.createControl("filter-envelope-release", 0.0, 10000.0, 550.0, new Exponential());
        this.controls.createBooleanControl("filter-envelope-loop", false);
        this.controls.createControl("modulation-envelope-attack", 0.0, 10000.0, 0.0, new Exponential());
        this.controls.createControl("modulation-envelope-decay", 0.0, 10000.0, 800.0, new Exponential());
        this.controls.createControl("modulation-envelope-sustain", 0.0, 1.0, 0.0, new Linear());
        this.controls.createControl("modulation-envelope-release", 0.0, 10000.0, 0.0, new Exponential());
        this.controls.createBooleanControl("modulation-envelope-loop", false);
        this.controls.createControl("primary-oscillator-octave-offset", -4.0, 4.0, 0.0, new Linear(), true);
        this.controls.createControl("primary-oscillator-detune-semi-tones", -12.0, 12.0, 0.0, new Linear());
        this.controls.createControl("primary-oscillator-phase-shift", -0.5, 0.5, 0.0, new Linear());
        this.controls.createControl("primary-oscillator-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("primary-oscillator-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("primary-oscillator-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("secondary-oscillator-octave-offset", -4.0, 4.0, 0.0, new Linear(), true);
        this.controls.createControl("secondary-oscillator-detune-semi-tones", -12.0, 12.0, 0.0, new Linear());
        this.controls.createControl("secondary-oscillator-phase-shift", -0.5, 0.5, 0.0, new Linear());
        this.controls.createControl("secondary-oscillator-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("secondary-oscillator-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("secondary-oscillator-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("noise-oscillator-volume", 0.0, 1.0, 0.0, new Linear());
        this.controls.createControl("primary-oscillator-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createControl("secondary-oscillator-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createControl("glide-length", 0.0, 1.0, 0.0, new Exponential());
        this.controls.createControl("lfo1-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("lfo2-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("lfo3-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("lfo1-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("lfo2-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("lfo3-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("delay-dry-wet-mix", 0.0, 1.0, 1.0, new Exponential());
        this.controls.createControl("delay-in-milliseconds", 0.0, 2500.0, 0.0, new Exponential());
        this.controls.createControl("delay-decay", 0.0, 1.0, 0.75, new Exponential());
        this.controls.createControl("reverb-dry-wet-mix", 0.0, 1.0, 1.0, new Exponential());
        this.controls.createControl("reverb-length", 1.0, 5.0, 1.0, new Linear());
        this.controls.createControl("chorus-dry-wet-mix", 0.0, 1.0, 0.5, new Exponential());
        this.controls.createControl("chorus-delay-in-milliseconds-1", 0.0, 20.0, 5.0, new Exponential());
        this.controls.createControl("chorus-delay-in-milliseconds-2", 0.0, 20.0, 7.0, new Exponential());
        this.controls.createControl("chorus-rate-1", 0.0, 15.0, 0.2, new Exponential());
        this.controls.createControl("chorus-rate-2", 0.0, 15.0, 0.5, new Exponential());
        this.controls.createControl("chorus-depth-1", 0.0, 7.0, 0.1, new Exponential());
        this.controls.createControl("chorus-depth-2", 0.0, 7.0, 0.2, new Exponential());
        this.controls.createBooleanControl("velocity-sensitive-keys", false);
        this.controls.createBooleanControl("clip", true);
        this.controls.createDiscreteControl("volume-envelope-type", this.envelopes.all(), "LinearADSR");
        this.controls.createDiscreteControl("filter-envelope-type", this.envelopes.all(), "LinearADSR");
        this.controls.createDiscreteControl("modulation-envelope-type", this.envelopes.all(), "ExponentialDecay");
        this.controls.createBooleanControl("lfo1-key-reset", true);
        this.controls.createBooleanControl("lfo2-key-reset", true);
        this.controls.createBooleanControl("lfo3-key-reset", true);
        this.controls.createBooleanControl("legato", false);
        this.controls.createDiscreteControl("filter", this.filters.all(), "Stilson4PoleLadderFilter");
    }

    public float getSampleRate() {
        return 44100.0f;
    }

    public Controls getControls() {
        return this.controls;
    }

    public Envelopes getEnvelopes() {
        return this.envelopes;
    }

    public KeyTimings getKeyTimings() {
        return this.keyTimings;
    }

    public ModulationMatrix getModulationMatrix() {
        return this.modulationMatrix;
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void selectTempoSource(boolean midiSyncOn) {
        if (midiSyncOn) {
            this.midiClockTempoSource.addSequencer(this.stepSequencer);
            this.midiClockTempoSource.addSequencer(this.arpeggiator);
            this.midiClockTempoSource.addSequencer(this.euclideanSequencer);
            this.mainLoopTempoSource.removeSequencer(this.euclideanSequencer);
            this.mainLoopTempoSource.removeSequencer(this.arpeggiator);
            this.mainLoopTempoSource.removeSequencer(this.stepSequencer);
        } else {
            this.mainLoopTempoSource.addSequencer(this.stepSequencer);
            this.mainLoopTempoSource.addSequencer(this.arpeggiator);
            this.mainLoopTempoSource.addSequencer(this.euclideanSequencer);
            this.midiClockTempoSource.removeSequencer(this.euclideanSequencer);
            this.midiClockTempoSource.removeSequencer(this.arpeggiator);
            this.midiClockTempoSource.removeSequencer(this.stepSequencer);
        }
    }

    public static void main(String[] args) throws LineUnavailableException {
        final Thief thief = new Thief();
        String headless = System.getProperty("headless");
        if (headless != null && !"false".equalsIgnoreCase(headless)) {
            thief.startEngine(Device.defaultDevice(AUDIO_FORMAT), SequencerVisualizer.noop(), Visualizer.noop());
        } else {
            final ThiefUI ui = new ThiefUI(thief);
            thief.startEngine(Device.defaultDevice(AUDIO_FORMAT), new ThiefUISequencerVisualizer(ui), new ThiefUIVisualizer(thief.getModulationMatrix(), ui));
            final JFrame window = ui.displayUI(new Consumer<Device>(){

                @Override
                public void accept(Device device) {
                    try {
                        thief.stopEngine();
                        thief.startEngine(device, new ThiefUISequencerVisualizer(ui), new ThiefUIVisualizer(thief.getModulationMatrix(), ui));
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Skins.setSkin(Skins.defaultSkin(), window);
                }
            });
        }
    }
}

