/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.FilterModule;
import net.jevring.frequencies.v2.modular.MixerModule;
import net.jevring.frequencies.v2.modular.NoiseModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.ControlledOscillator;
import net.jevring.scoundrel.voices.DrumVoice;

public class SnareVoice
implements DrumVoice {
    public static final int NOTE = 62;
    public static final int VOICE_INDEX = 1;
    private final DecayEnvelope volumeEnvelope = new ExponentialDecayEnvelope();
    private final DecayEnvelope noiseEnvelope = new ExponentialDecayEnvelope();
    private final DecayEnvelope pitchEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public SnareVoice(Controls controls, double sampleRate, Filters filters) {
        controls.getControl("snare-volume-envelope-decay").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                SnareVoice.this.volumeEnvelope.setDecayInMillis((long)newValue);
            }
        });
        controls.getControl("snare-pitch-envelope-decay").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                SnareVoice.this.pitchEnvelope.setDecayInMillis((long)newValue);
            }
        });
        controls.getControl("snare-noise-envelope-decay").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                SnareVoice.this.noiseEnvelope.setDecayInMillis((long)newValue);
            }
        });
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        EnvelopeModule noiseEnvelopeModule = new EnvelopeModule(this.noiseEnvelope, sampleRate);
        EnvelopeModule pitchEnvelopeModule = new EnvelopeModule(this.pitchEnvelope, sampleRate);
        ControlledOscillator oscillator = new ControlledOscillator("snare", controls, sampleRate, true);
        oscillator.setFrequencyModulationModulationRange(96.0);
        OscillatorModule oscillatorModule = new OscillatorModule(oscillator);
        oscillatorModule.getFrequencyModulation().connect(new AttenuverterModule(controls.getControl("snare-pitch-envelope-modulation-depth"), pitchEnvelopeModule));
        controls.getControl("snare-variable-waveform").set(0.0, 0.0, 3.0, this);
        NoiseModule noiseModule = new NoiseModule();
        FilterModule filterModule = new FilterModule(new ControlledFilter("snare-noise", controls, filters));
        filterModule.setInput(noiseModule);
        ScalingModule applyVolumeEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelope.setInput(oscillatorModule);
        applyVolumeEnvelope.setScaleInput(volumeEnvelopeModule);
        ScalingModule applyNoiseEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyNoiseEnvelope.setInput(filterModule);
        applyNoiseEnvelope.setScaleInput(noiseEnvelopeModule);
        MixerModule lastMixer = new MixerModule();
        lastMixer.add(applyVolumeEnvelope, controls.getControl("snare-waveform-volume"));
        lastMixer.add(applyNoiseEnvelope, controls.getControl("snare-noise-volume"));
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("snare-level"), lastMixer);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        if (this.volumeEnvelope.getDecayInMillis() > this.noiseEnvelope.getDecayInMillis()) {
            return this.volumeEnvelope;
        }
        return this.noiseEnvelope;
    }

    @Override
    public String getName() {
        return "Snare";
    }

    @Override
    public String getControlPrefix() {
        return "snare";
    }

    @Override
    public int getVoiceIndex() {
        return 1;
    }

    @Override
    public int getInstructionNote() {
        return 62;
    }
}

