/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.FilterModule;
import net.jevring.frequencies.v2.modular.MixerModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.QuantizedWaveform;
import net.jevring.frequencies.v2.waveforms.VariableWaveForm;
import net.jevring.scoundrel.voices.DrumVoice;

public class LaserTomVoice
implements DrumVoice {
    public static final int NOTE = 65;
    public static final int VOICE_INDEX = 3;
    private final DecayEnvelope volumeEnvelope = new ExponentialDecayEnvelope();
    private final DecayEnvelope pitchEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public LaserTomVoice(Controls controls, double sampleRate, Filters filters) {
        controls.getControl("laser-tom-volume-envelope-decay").addRawLongListener(this.volumeEnvelope::setDecayInMillis);
        controls.getControl("laser-tom-pitch-envelope-decay").addRawLongListener(this.pitchEnvelope::setDecayInMillis);
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        EnvelopeModule pitchEnvelopeModule = new EnvelopeModule(this.pitchEnvelope, sampleRate);
        Oscillator osc1 = new Oscillator(sampleRate);
        osc1.setFrequencyModulationModulationRange(96.0);
        osc1.setWaveform(new QuantizedWaveform(new VariableWaveForm()));
        OscillatorModule osc1Module = new OscillatorModule(osc1);
        osc1Module.getFrequencyModulation().connect(new AttenuverterModule(controls.getControl("laser-tom-pitch-envelope-modulation-depth"), pitchEnvelopeModule));
        controls.getControl("laser-tom-osc-1-variable-waveform").addRawDoubleListener(osc1::setWaveformVariation);
        controls.getControl("laser-tom-osc-1-variable-waveform").set(0.0, 1.0, 3.0, this);
        Oscillator osc2 = new Oscillator(sampleRate);
        osc2.setFrequencyModulationModulationRange(96.0);
        osc2.setSemitoneOffset(12.0);
        osc2.setWaveform(new QuantizedWaveform(new VariableWaveForm()));
        OscillatorModule osc2Module = new OscillatorModule(osc2);
        osc2Module.getFrequencyModulation().connect(new AttenuverterModule(controls.getControl("laser-tom-pitch-envelope-modulation-depth"), pitchEnvelopeModule));
        controls.getControl("laser-tom-osc-2-variable-waveform").addRawDoubleListener(osc2::setWaveformVariation);
        controls.getControl("laser-tom-osc-2-variable-waveform").set(0.0, 1.0, 3.0, this);
        MixerModule oscillatorMixer = new MixerModule();
        oscillatorMixer.add(osc1Module, controls.getControl("laser-tom-osc-1-volume"));
        oscillatorMixer.add(osc2Module, controls.getControl("laser-tom-osc-2-volume"));
        FilterModule filterModule = new FilterModule(new ControlledFilter("laser-tom", controls, filters));
        filterModule.setInput(oscillatorMixer);
        ScalingModule applyPitchEnvelopeToFilter = new ScalingModule(BooleanControl.alwaysTrue());
        applyPitchEnvelopeToFilter.setInput(filterModule);
        applyPitchEnvelopeToFilter.setScaleInput(pitchEnvelopeModule);
        ScalingModule applyVolumeEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelope.setInput(filterModule);
        applyVolumeEnvelope.setScaleInput(volumeEnvelopeModule);
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("laser-tom-level"), applyVolumeEnvelope);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        return this.volumeEnvelope;
    }

    @Override
    public String getName() {
        return "Laser tom";
    }

    @Override
    public String getControlPrefix() {
        return "laser-tom";
    }

    @Override
    public int getVoiceIndex() {
        return 3;
    }

    @Override
    public int getInstructionNote() {
        return 65;
    }
}

