/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.input;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.envelopes.Phase;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.input.InstructionInput;
import net.jevring.frequencies.v2.input.KeyTiming;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.scoundrel.voices.DrumVoice;

public class DrumInput
implements InstructionInput {
    private final KeyTimings keyTimings;
    private final DrumVoice[] voices;
    private final Instruction[] previousInstruction;

    public DrumInput(KeyTimings keyTimings, DrumVoice[] voices) {
        this.keyTimings = keyTimings;
        this.voices = voices;
        this.previousInstruction = new Instruction[voices.length];
    }

    @Override
    public List<Instruction> inputInstructions() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (int i = 0; i < this.voices.length; ++i) {
            instructions.add(null);
        }
        List<KeyTiming> keys = this.keyTimings.keys();
        for (KeyTiming key : keys) {
            int voice;
            if (key.key() == 60) {
                voice = 0;
                instructions.set(voice, this.keyTimingToInstruction(key, 42.0, voice));
                continue;
            }
            if (key.key() == 62) {
                voice = 1;
                instructions.set(voice, this.keyTimingToInstruction(key, 82.41, voice));
                continue;
            }
            if (key.key() == 64) {
                voice = 2;
                instructions.set(voice, this.keyTimingToInstruction(key, 130.81, voice));
                continue;
            }
            if (key.key() == 65) {
                voice = 3;
                instructions.set(voice, this.keyTimingToInstruction(key, 130.81, voice));
                continue;
            }
            if (key.key() == 67) {
                voice = 4;
                instructions.set(voice, this.keyTimingToInstruction(key, 0.0, voice));
                continue;
            }
            if (key.key() == 69) {
                voice = 5;
                instructions.set(voice, this.keyTimingToInstruction(key, 0.0, voice));
                continue;
            }
            if (key.key() != 71) continue;
            voice = 6;
            instructions.set(voice, this.keyTimingToInstruction(key, 1318.51, voice));
        }
        return instructions;
    }

    private Instruction keyTimingToInstruction(KeyTiming keyTiming, double frequency, int voice) {
        int key = keyTiming.key();
        long age = keyTiming.nanosecondsActivated() + keyTiming.nanosecondsDeactivated();
        Phase volumeEnvelopePhase = this.voices[voice].getVolumeEnvelope().phase(keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated());
        if (volumeEnvelopePhase != Phase.IDLE) {
            Instruction instruction;
            boolean newInstruction = this.previousInstruction[voice] == null || this.previousInstruction[voice].getKey() != key || this.previousInstruction[voice].getTimeDown() != keyTiming.lastTimeDown() ? this.previousInstruction[voice] == null || this.previousInstruction[voice].getTimeDown() != keyTiming.lastTimeDown() : false;
            this.previousInstruction[voice] = instruction = new Instruction(key, age, frequency, newInstruction, volumeEnvelopePhase, keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated(), keyTiming.velocity(), keyTiming.lastTimeDown());
            return instruction;
        }
        return null;
    }
}

