/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms.open303;

import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.waveforms.open303.InterpolatedWaveform;

public class Open303SquareWaveform
extends InterpolatedWaveform {
    private final double tanhShaperFactor = Open303SquareWaveform.dB2amp(36.9);
    private final double tanhShaperOffset = 4.37;
    private final double squarePhaseShift = 180.0;

    public Open303SquareWaveform() {
        int n;
        int N = 2048;
        double k = 0.5;
        int N1 = (int)Clamp.clamp(Math.round(k * (double)(N - 1)), 1.0, (double)(N - 1));
        int N2 = N - N1;
        double s1 = 1.0 / (double)(N1 - 1);
        double s2 = 1.0 / (double)N2;
        for (n = 0; n < N1; ++n) {
            this.prototypeTable[n] = s1 * (double)n;
        }
        for (n = N1; n < N; ++n) {
            this.prototypeTable[n] = -1.0 + s2 * (double)(n - N1);
        }
        for (n = 0; n < N; ++n) {
            this.prototypeTable[n] = -Math.tanh(this.tanhShaperFactor * this.prototypeTable[n] + 4.37);
        }
        int nShift = (int)Math.round((double)N * 180.0 / 360.0);
        this.circularShift(this.prototypeTable, N, nShift);
    }

    private static double dB2amp(double dB) {
        return Math.exp(dB * 0.11512925464970228);
    }

    void circularShift(double[] buffer, int length, int numPositions) {
        int na;
        for (na = Math.abs(numPositions); na > length; na -= length) {
        }
        double[] tmp = new double[na];
        if (numPositions < 0) {
            System.arraycopy(buffer, 0, tmp, 0, na);
            System.arraycopy(buffer, na, buffer, 0, length - na);
            System.arraycopy(tmp, 0, buffer, length - na, na);
        } else if (numPositions > 0) {
            System.arraycopy(buffer, length - na, tmp, 0, na);
            System.arraycopy(buffer, 0, buffer, na, length - na);
            System.arraycopy(tmp, 0, buffer, 0, na);
        }
    }

    public String toString() {
        return "Open303Sawtooth";
    }
}

