/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms.open303;

import net.jevring.frequencies.v2.waveforms.open303.InterpolatedWaveform;

public class Open303MoogSawtoothWaveform
extends InterpolatedWaveform {
    public Open303MoogSawtoothWaveform() {
        int i;
        for (i = 0; i < 1024; ++i) {
            this.prototypeTable[i] = (double)(2 * i) / 2048.0;
        }
        for (i = 1024; i < 2048; ++i) {
            this.prototypeTable[i] = (double)(2 * i) / 2048.0 - 2.0;
        }
        for (i = 0; i < 1024; ++i) {
            int n = i;
            this.prototypeTable[n] = this.prototypeTable[n] + (1.0 - (double)(4 * i) / 2048.0);
        }
        for (i = 1024; i < 2048; ++i) {
            int n = i;
            this.prototypeTable[n] = this.prototypeTable[n] + (-1.0 + (double)(4 * i) / 2048.0);
        }
        this.removeDC();
        this.normalize();
    }

    private void removeDC() {
        int i;
        double dcOffset = 0.0;
        for (i = 0; i < 2048; ++i) {
            dcOffset += this.prototypeTable[i];
        }
        dcOffset /= 2048.0;
        i = 0;
        while (i < 2048) {
            int n = i++;
            this.prototypeTable[n] = this.prototypeTable[n] - dcOffset;
        }
    }

    private void normalize() {
        int i;
        double max = 0.0;
        for (i = 0; i < 2048; ++i) {
            if (!(Math.abs(this.prototypeTable[i]) > max)) continue;
            max = Math.abs(this.prototypeTable[i]);
        }
        double scale = 1.0 / max;
        i = 0;
        while (i < 2048) {
            int n = i++;
            this.prototypeTable[n] = this.prototypeTable[n] * scale;
        }
    }

    public String toString() {
        return "Open303MoogSawtooth";
    }
}

