/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.waveforms.PhaseShiftedWaveform;
import net.jevring.frequencies.v2.waveforms.PulseWaveform;
import net.jevring.frequencies.v2.waveforms.SawtoothWaveform;
import net.jevring.frequencies.v2.waveforms.SineWaveform;
import net.jevring.frequencies.v2.waveforms.TriangleWaveform;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class VariableWaveForm
implements Waveform {
    private static final Waveform sine = new PhaseShiftedWaveform(new SineWaveform(), -0.5);
    private static final Waveform triangle = new PhaseShiftedWaveform(new TriangleWaveform(), -0.5);
    private static final Waveform saw = new SawtoothWaveform(false);
    private static final Waveform square = new PulseWaveform();
    private static final Waveform[] waveforms = new Waveform[]{sine, triangle, saw, square};

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        double clampedWaveformInterpolation = Clamp.clamp(waveformInterpolation, 0.0, 3.0);
        int i = (int)Math.floor(clampedWaveformInterpolation);
        Waveform w1 = waveforms[i];
        if (i == 3) {
            return w1.valueAt(cycleProgress, shape, oddCycle, quantizationSteps, clampedWaveformInterpolation);
        }
        Waveform w2 = waveforms[i + 1];
        double v1 = w1.valueAt(cycleProgress, shape, oddCycle, quantizationSteps, clampedWaveformInterpolation);
        double v2 = w2.valueAt(cycleProgress, shape, oddCycle, quantizationSteps, clampedWaveformInterpolation);
        double r2 = clampedWaveformInterpolation - (double)i;
        double r1 = 1.0 - r2;
        return v1 * r1 + v2 * r2;
    }

    public String toString() {
        return "Variable";
    }
}

