/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import net.jevring.frequencies.v2.waveforms.SawtoothWaveform;
import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class StepUpWaveform
implements Waveform {
    private final WaveShaper waveShaper = new WaveShaper();
    private final SawtoothWaveform sawtoothUpWaveform = new SawtoothWaveform(true);
    private final int steps;

    public StepUpWaveform(int steps) {
        this.steps = steps;
    }

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        return this.waveShaper.shapeSample(this.baseValueAt(cycleProgress), shape);
    }

    private double baseValueAt(double cycleProgress) {
        double perStep = 1.0 / (double)this.steps;
        for (int i = 0; i < this.steps; ++i) {
            double steppedProgress = (double)i * perStep;
            if (!(steppedProgress < cycleProgress) || !(cycleProgress < steppedProgress + perStep)) continue;
            return this.sawtoothUpWaveform.valueAt(steppedProgress, 0.0, true, 0, 0.0);
        }
        return -1.0;
    }

    public String toString() {
        return this.steps + "StepUp";
    }
}

