/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class SawtoothDownWaveform
implements Waveform {
    private final WaveShaper waveShaper = new WaveShaper();

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        return this.waveShaper.shapeSample(this.baseValueAt(cycleProgress), shape);
    }

    private double baseValueAt(double cycleProgress) {
        double c = (cycleProgress + 0.5) % 1.0;
        return -1.0 * (2.0 * (c - Math.floor(c + 0.5)));
    }

    public String toString() {
        return "SawtoothDown";
    }

    public static void main(String[] args) {
        SawtoothDownWaveform w = new SawtoothDownWaveform();
        for (double d = 0.0; d <= 1.0; d += 0.01) {
            System.out.printf("w.valueAt(" + d + ", 0) = %.3f%n", w.valueAt(d, 0.0, true, 0, 0.0));
        }
    }
}

