/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import net.jevring.frequencies.v2.waveforms.Waveform;

public class QuantizedWaveform
implements Waveform {
    private final Waveform waveform;

    public QuantizedWaveform(Waveform waveform) {
        this.waveform = waveform;
    }

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        double v = this.waveform.valueAt(cycleProgress, shape, oddCycle, quantizationSteps, waveformInterpolation);
        if (quantizationSteps == 16) {
            return v;
        }
        double d = 1.0 / (double)quantizationSteps;
        return d * Math.floor(v / d + 0.5);
    }
}

