/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import net.jevring.frequencies.v2.waveforms.TriangleWaveform;
import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class PyramidWaveform
implements Waveform {
    private final WaveShaper waveShaper = new WaveShaper();
    private final TriangleWaveform triangleWaveform = new TriangleWaveform();
    private final int steps;

    public PyramidWaveform(int steps) {
        this.steps = steps;
    }

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        return this.waveShaper.shapeSample(this.baseValueAt(cycleProgress), shape);
    }

    private double baseValueAt(double cycleProgress) {
        double perStep = 1.0 / (double)(this.steps * 2);
        for (int i = 0; i < this.steps * 2; ++i) {
            double steppedProgress = (double)i * perStep;
            if (!(steppedProgress < cycleProgress) || !(cycleProgress < steppedProgress + perStep)) continue;
            return this.triangleWaveform.valueAt(steppedProgress, 0.0, true, 0, 0.0);
        }
        return -1.0;
    }

    public String toString() {
        return this.steps + "Pyramid";
    }
}

