/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.util;

import java.util.Locale;
import java.util.function.DoubleFunction;
import net.jevring.frequencies.v2.input.midi.MidiNoteNameMapper;
import net.jevring.frequencies.v2.util.TempoTools;

public enum ValueFormatter {
    PPQN(d -> TempoTools.ppqnName((int)d)),
    MIDI_NOTE_TO_NAME(d -> MidiNoteNameMapper.noteName((int)d)),
    INTEGER(d -> String.format(Locale.US, "%d", Math.round(d))),
    INTEGER_16_OFF(d -> d == 16.0 ? "OFF" : String.format(Locale.US, "%d", Math.round(d))),
    PURE(d -> String.format(Locale.US, "%.2f", d)),
    LOW_FREQUENCY(d -> String.format(Locale.US, "%.2f Hz", d)),
    FREQUENCY(d -> String.format(Locale.US, "%.0f Hz", d)),
    PERCENT(d -> String.format(Locale.US, "%.0f %%", d * 100.0)),
    SEMITONES(d -> String.format(Locale.US, "%.2f st", d)),
    SECONDS(d -> String.format(Locale.US, "%.2f s", d)),
    LOW_MILLISECONDS(d -> String.format(Locale.US, "%.2f ms", d)),
    MILLISECONDS(d -> String.format(Locale.US, "%.0f ms", d));

    private final DoubleFunction<String> formatter;

    private ValueFormatter(DoubleFunction<String> formatter) {
        this.formatter = formatter;
    }

    public String format(double d) {
        return this.formatter.apply(d);
    }
}

