/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Bytes {
    public static int convertToInt(byte[] bytes) {
        return Bytes.convertToInt(bytes, 0, bytes.length);
    }

    public static int convertToInt(byte[] bytes, int start, int length) {
        switch (length) {
            case 1: {
                return bytes[start];
            }
            case 2: {
                return bytes[start] << 8 | bytes[start + 1] & 0xFF;
            }
            case 3: {
                return bytes[start] << 16 | (bytes[start + 1] & 0xFF) << 8 | bytes[start + 2] & 0xFF;
            }
            case 4: {
                return bytes[start] << 24 | (bytes[start + 1] & 0xFF) << 16 | (bytes[start + 2] & 0xFF) << 8 | bytes[start + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("Cannot handle byte arrays of size " + length);
    }

    public static byte[] convertToBytes(int value, int sizeOfArray) {
        byte[] bytes = new byte[sizeOfArray];
        switch (sizeOfArray) {
            case 1: {
                bytes[0] = (byte)value;
                break;
            }
            case 2: {
                bytes[1] = (byte)(value & 0xFF);
                bytes[0] = (byte)(value >> 8 & 0xFF);
                break;
            }
            case 3: {
                bytes[2] = (byte)(value & 0xFF);
                bytes[1] = (byte)(value >> 8 & 0xFF);
                bytes[0] = (byte)(value >> 16 & 0xFF);
                break;
            }
            case 4: {
                bytes[3] = (byte)(value & 0xFF);
                bytes[2] = (byte)(value >> 8 & 0xFF);
                bytes[1] = (byte)(value >> 16 & 0xFF);
                bytes[0] = (byte)(value >> 24 & 0xFF);
            }
        }
        return bytes;
    }

    public static void writeShort(short value, int index, byte[] bytes) {
        bytes[index + 1] = (byte)(value & 0xFF);
        bytes[index] = (byte)(value >> 8 & 0xFF);
    }

    public static byte[] convertToBytesViaByteBuffer(int value, int sizeOfArray) {
        return ByteBuffer.allocate(sizeOfArray).putInt(value).array();
    }

    public static byte[] convertToBytesViaByteBuffer(short value, int sizeOfArray) {
        return ByteBuffer.allocate(sizeOfArray).putShort(value).array();
    }

    public static int convertToIntViaByteBuffers(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static short convertToShortViaByteBuffers(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getShort();
    }

    public static void main(String[] args) {
        Bytes.test(1, -127, 127);
        Bytes.test(2, Short.MIN_VALUE, Short.MAX_VALUE);
        Bytes.test(3, -2048383, 2048383);
        Bytes.test(4, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static void test(int size, int start, int end) {
        for (int i = start; i <= end; ++i) {
            int value;
            int s;
            byte[] bytesVerification;
            byte[] bytes = Bytes.convertToBytes(i, size);
            if (size == 4) {
                bytesVerification = Bytes.convertToBytesViaByteBuffer(i, size);
                if (!Arrays.equals(bytes, bytesVerification)) {
                    System.out.println("We got up to " + (i - 1) + " in size " + size + " before breaking [array]");
                    return;
                }
                s = Bytes.convertToIntViaByteBuffers(bytes);
                if (s != i) {
                    System.out.println("We got up to " + (i - 1) + " in size " + size + " before breaking [bb-int]");
                    return;
                }
            }
            if (size == 2) {
                bytesVerification = Bytes.convertToBytesViaByteBuffer((short)i, size);
                if (!Arrays.equals(bytes, bytesVerification)) {
                    System.out.println("We got up to " + (i - 1) + " in size " + size + " before breaking [array]");
                    return;
                }
                s = Bytes.convertToShortViaByteBuffers(bytes);
                if (s != i) {
                    System.out.println("We got up to " + (i - 1) + " in size " + size + " before breaking [bb-short]");
                    return;
                }
            }
            if ((value = Bytes.convertToInt(bytes)) == i) continue;
            System.out.println("We got up to " + (i - 1) + " in size " + size + " before breaking [int]");
            return;
        }
        System.out.println("Complete from " + start + " to " + end + " in size " + size);
    }
}

