/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SwingUtils {
    public static JFrame showWindowFor(String name, final JComponent contentPane, final int width, final int height) {
        final JFrame frame = new JFrame(name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setContentPane(contentPane);
                frame.pack();
                frame.setVisible(true);
                frame.setResizable(false);
                Dimension size = new Dimension(width, height);
                int x = 300;
                int y = 100;
                frame.setLocation(x, y);
                frame.setDefaultCloseOperation(3);
                frame.setPreferredSize(size);
                frame.setSize(size);
            }
        });
        return frame;
    }

    public static JFrame showWindowFor(String name, final JComponent contentPane, final boolean fixedSize) {
        final JFrame frame = new JFrame(name);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setContentPane(contentPane);
                frame.pack();
                frame.setVisible(true);
                frame.setResizable(false);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension size = fixedSize ? new Dimension(1332, 875) : frame.getSize();
                int x = (int)(screenSize.getWidth() / 2.0 - size.getWidth() / 2.0);
                int y = (int)(screenSize.getHeight() / 2.0 - size.getHeight() / 2.0);
                if (fixedSize) {
                    x = 300;
                    y = 100;
                }
                frame.setLocation(x, y);
                frame.setDefaultCloseOperation(3);
                if (fixedSize) {
                    frame.setPreferredSize(size);
                    frame.setSize(size);
                }
            }
        });
        return frame;
    }
}

