/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;
import net.jevring.frequencies.v2.input.KeyTimings;

public class KeyboardInput
implements KeyListener {
    private final Set<Integer> keysDown = new HashSet<Integer>();
    private final KeyTimings keyTimings;

    public KeyboardInput(KeyTimings keyTimings) {
        this.keyTimings = keyTimings;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = this.toMidi(e);
        if (this.keysDown.add(key) && key >= 0) {
            this.keyTimings.down(key, 127);
        }
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = this.toMidi(e);
        this.keysDown.remove(key);
        if (key >= 0) {
            this.keyTimings.up(key);
        }
        e.consume();
    }

    private int toMidi(KeyEvent e) {
        return switch (e.getKeyCode()) {
            case 65 -> 60;
            case 87 -> 61;
            case 83 -> 62;
            case 69 -> 63;
            case 68 -> 64;
            case 70 -> 65;
            case 84 -> 66;
            case 71 -> 67;
            case 89 -> 68;
            case 72 -> 69;
            case 85 -> 70;
            case 74 -> 71;
            default -> -1;
        };
    }
}

