/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import net.jevring.frequencies.v2.ui.JOscilloscope;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;

public class JWaveformDisplay
extends JComponent
implements JOscilloscope {
    private final int maxXAxis = 1200;
    private final int maxYAxis = 100;
    private final int yOffset = 150;
    private final int xOffset = 5;
    private volatile Skin skin = Skins.BLUE_RED;
    private volatile double[] data = new double[1200];
    private volatile int lastChunkEnd = 0;

    public JWaveformDisplay() {
        Dimension size = new Dimension(1250, 300);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
    }

    @Override
    public void newChunk(double[] chunk) {
        int p = this.lastChunkEnd;
        for (int i = 0; i < chunk.length; ++i) {
            double v = chunk[i];
            this.data[p++ % this.data.length] = v;
        }
        this.lastChunkEnd = p;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.skin.foreground());
        g.drawLine(5, 15, 5, 285);
        g.drawLine(5, 150, 1205, 150);
        if (this.data != null) {
            int i;
            Polygon p = new Polygon();
            int x = 5;
            for (i = 0; i < this.data.length; ++i) {
                int scaledValue = (int)(this.data[i] * 100.0);
                p.addPoint(x, 150 - scaledValue);
                if (++x >= 1200) break;
            }
            g.setColor(this.skin.modulationRange());
            g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
            g.setColor(this.skin.modulationValue());
            for (i = 0; i < p.npoints; ++i) {
                g.drawRect(p.xpoints[i], p.ypoints[i], 1, 1);
            }
        }
    }
}

