/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.input.Sequencer;
import net.jevring.frequencies.v2.input.arpeggiator.Arpeggiator;
import net.jevring.frequencies.v2.input.euclidean.EuclideanSequencer;
import net.jevring.frequencies.v2.input.sequencer.StepSequencer;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JControlledCheckBox;
import net.jevring.frequencies.v2.ui.JControlledComboBox;
import net.jevring.frequencies.v2.ui.JControlledTextIconButton;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.ui.JLight;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JTempoPanel
extends JPanel {
    private final JLight[] sequencerLeds = new JLight[16];
    private final Controls controls;
    private final JControlledTextIconButton stepSequencerStart;
    private final JControlledTextIconButton arpeggiatorStart;
    private final JControlledTextIconButton euclideanSequencerStart;

    public JTempoPanel(Controls controls) {
        this.controls = controls;
        this.setLayout(new BoxLayout(this, 2));
        JPanel tempoPanel = (JPanel)this.add(new JPanel(new GridBagLayout()));
        tempoPanel.setBorder(BorderFactory.createTitledBorder("Tempo"));
        JControlledCheckBox midiClockIn = new JControlledCheckBox("MIDI Clock IN", this.bc("receive-midi-clock-active"));
        midiClockIn.setHorizontalTextPosition(0);
        midiClockIn.setVerticalTextPosition(3);
        JKnob swingKnob = new JKnob("Swing", this.c("swing"), ValueFormatter.PERCENT);
        swingKnob.setDisabled(true);
        JKnob tempoKnob = new JKnob("Tempo", this.c("tempo"), ValueFormatter.INTEGER);
        JKnob rateKnob = new JKnob("Rate", this.c("rate"), ValueFormatter.PPQN);
        tempoPanel.add((Component)tempoKnob, GridBadLayoutUtils.gbc(0, 1, 1, 1));
        tempoPanel.add((Component)rateKnob, GridBadLayoutUtils.gbc(0, 2, 1, 1));
        tempoPanel.add((Component)midiClockIn, GridBadLayoutUtils.gbc(1, 2, 1, 1));
        JPanel arpeggiatorPanel = (JPanel)this.add(new JPanel(new GridBagLayout()));
        arpeggiatorPanel.setBorder(BorderFactory.createTitledBorder("Arpeggiator"));
        this.arpeggiatorStart = new JControlledTextIconButton('\u25b6', this.bc("arpeggiator-active"), true);
        JControlledTextIconButton arpeggiatorStop = new JControlledTextIconButton('\u23f9', this.bc("arpeggiator-active"), false);
        JKnob arpeggiatorGateKnob = new JKnob("Gate", this.c("arpeggiator-gate"), ValueFormatter.PERCENT);
        JKnob arpeggiatorOctavesKnob = new JKnob("Octaves", this.c("arpeggiator-octaves"), ValueFormatter.INTEGER);
        arpeggiatorPanel.add((Component)arpeggiatorOctavesKnob, GridBadLayoutUtils.gbc(0, 0, 1, 1));
        arpeggiatorPanel.add((Component)arpeggiatorGateKnob, GridBadLayoutUtils.gbc(0, 1, 1, 2));
        arpeggiatorPanel.add(this.arpMode(), GridBadLayoutUtils.gbc(1, 0, 1, 1));
        arpeggiatorPanel.add((Component)arpeggiatorStop, GridBadLayoutUtils.gbc(1, 1, 1, 1));
        arpeggiatorPanel.add((Component)this.arpeggiatorStart, GridBadLayoutUtils.gbc(1, 2, 1, 1));
        JPanel euclideanSequencerPanel = (JPanel)this.add(new JPanel(new GridBagLayout()));
        euclideanSequencerPanel.setBorder(BorderFactory.createTitledBorder("Euclidean sequencer"));
        this.euclideanSequencerStart = new JControlledTextIconButton('\u25b6', this.bc("euclidean-sequencer-active"), true);
        JControlledTextIconButton euclideanSequencerStop = new JControlledTextIconButton('\u23f9', this.bc("euclidean-sequencer-active"), false);
        JKnob euclideanNoteKnob = new JKnob("Note", this.c("euclidean-sequencer-note"), ValueFormatter.MIDI_NOTE_TO_NAME);
        JKnob euclideanGateKnob = new JKnob("Gate", this.c("euclidean-sequencer-gate"), ValueFormatter.PERCENT);
        JKnob euclideanOuterSteps = new JKnob("Outer", this.c("euclidean-sequencer-outer-steps"), ValueFormatter.INTEGER);
        JKnob euclideanInnerSteps = new JKnob("Inner", this.c("euclidean-sequencer-inner-steps"), ValueFormatter.INTEGER);
        JKnob euclideanRotation = new JKnob("Rotation", this.c("euclidean-sequencer-rotation"), ValueFormatter.INTEGER);
        euclideanSequencerPanel.add((Component)euclideanOuterSteps, GridBadLayoutUtils.gbc(0, 0, 1, 1));
        euclideanSequencerPanel.add((Component)euclideanInnerSteps, GridBadLayoutUtils.gbc(1, 0, 1, 1));
        euclideanSequencerPanel.add((Component)euclideanRotation, GridBadLayoutUtils.gbc(2, 0, 1, 1));
        euclideanSequencerPanel.add((Component)euclideanNoteKnob, GridBadLayoutUtils.gbc(0, 1, 1, 2));
        euclideanSequencerPanel.add((Component)euclideanGateKnob, GridBadLayoutUtils.gbc(1, 1, 1, 2));
        euclideanSequencerPanel.add((Component)euclideanSequencerStop, GridBadLayoutUtils.gbc(2, 1, 1, 1));
        euclideanSequencerPanel.add((Component)this.euclideanSequencerStart, GridBadLayoutUtils.gbc(2, 2, 1, 1));
        JPanel stepSequencerPanel = (JPanel)this.add(new JPanel(new GridBagLayout()));
        stepSequencerPanel.setBorder(BorderFactory.createTitledBorder("Step sequencer"));
        for (int step = 0; step < 16; ++step) {
            JKnob note = new JKnob("Note", this.c("sequencer-note-" + step), ValueFormatter.MIDI_NOTE_TO_NAME);
            JKnob gate = new JKnob("Gate", this.c("sequencer-gate-" + step), ValueFormatter.PERCENT);
            JLight led = new JLight();
            JLabel stepLabel = new JLabel(String.valueOf(step + 1));
            led.setAlignmentX(0.5f);
            stepLabel.setAlignmentX(0.5f);
            stepLabel.setHorizontalAlignment(0);
            stepSequencerPanel.add((Component)note, GridBadLayoutUtils.gbc(step, 0, 1, 1));
            stepSequencerPanel.add((Component)gate, GridBadLayoutUtils.gbc(step, 1, 1, 2));
            stepSequencerPanel.add((Component)led, GridBadLayoutUtils.gbc(step, 3, 1, 1));
            stepSequencerPanel.add((Component)stepLabel, GridBadLayoutUtils.gbc(step, 4, 1, 1));
            this.sequencerLeds[step] = led;
        }
        this.stepSequencerStart = new JControlledTextIconButton('\u25b6', this.bc("sequencer-active"), true);
        JControlledTextIconButton stepSequencerStop = new JControlledTextIconButton('\u23f9', this.bc("sequencer-active"), false);
        JControlledTextIconButton stepSequencerRecord = new JControlledTextIconButton('\u23fa', this.bc("sequencer-listen"), true);
        stepSequencerStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTempoPanel.this.bc("sequencer-listen").set(false, this);
            }
        });
        this.stepSequencerStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTempoPanel.this.bc("sequencer-listen").set(false, this);
            }
        });
        JKnob sequencerSteps = new JKnob("Steps", this.c("sequencer-steps"), ValueFormatter.INTEGER);
        stepSequencerPanel.add((Component)sequencerSteps, GridBadLayoutUtils.gbc(17, 0, 1, 1));
        stepSequencerPanel.add((Component)stepSequencerRecord, GridBadLayoutUtils.gbc(17, 1, 1, 1));
        stepSequencerPanel.add((Component)stepSequencerStop, GridBadLayoutUtils.gbc(17, 2, 1, 1));
        stepSequencerPanel.add((Component)this.stepSequencerStart, GridBadLayoutUtils.gbc(17, 3, 1, 2));
        euclideanSequencerStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTempoPanel.this.euclideanSequencerStart.setHighlightOn(false);
            }
        });
        arpeggiatorStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTempoPanel.this.arpeggiatorStart.setHighlightOn(false);
            }
        });
        stepSequencerStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTempoPanel.this.stepSequencerStart.setHighlightOn(false);
            }
        });
    }

    private JComboBox<String> arpMode() {
        JControlledComboBox modeBox = new JControlledComboBox(this.controls.getDiscreteControl("arpeggiator-mode"), 20);
        modeBox.setFont(new Font("Monospaced", 0, 18));
        final ListCellRenderer originalRenderer = modeBox.getRenderer();
        modeBox.setRenderer(new ListCellRenderer<String>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                String renderedValue = switch (value) {
                    case "UP" -> "\u21c8";
                    case "DOWN" -> "\u21ca";
                    case "UP_AND_DOWN" -> "\u21c5";
                    case "RANDOM" -> "\u2608";
                    default -> value;
                };
                return originalRenderer.getListCellRendererComponent(list, renderedValue, index, isSelected, cellHasFocus);
            }
        });
        return modeBox;
    }

    private Control c(String key) {
        return this.controls.getControl(key);
    }

    private BooleanControl bc(String key) {
        return this.controls.getBooleanControl(key);
    }

    public void step(int step, boolean on) {
        if (step >= 0 && step < this.sequencerLeds.length) {
            JLight led = this.sequencerLeds[step];
            if (on) {
                led.on(Color.RED);
            } else {
                led.off();
            }
        }
    }

    public void beat(Sequencer sequencer) {
        if (sequencer instanceof EuclideanSequencer) {
            this.euclideanSequencerStart.setHighlightOn(!this.euclideanSequencerStart.isHighlightOn());
        } else if (sequencer instanceof Arpeggiator) {
            this.arpeggiatorStart.setHighlightOn(!this.arpeggiatorStart.isHighlightOn());
        } else if (sequencer instanceof StepSequencer) {
            this.stepSequencerStart.setHighlightOn(!this.stepSequencerStart.isHighlightOn());
        }
    }
}

