/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixRow;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;
import net.jevring.frequencies.v2.ui.JSmallKnob;
import net.jevring.frequencies.v2.ui.Skins;

public class JModulationMatrix
extends JPanel {
    private static final int rowHeight = 25;
    private static final int rows = 13;
    private final ModulationMatrix modulationMatrix;

    public JModulationMatrix(ModulationMatrix modulationMatrix) {
        this.modulationMatrix = modulationMatrix;
        this.setBorder(new EtchedBorder());
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        this.setBorder(new TitledBorder("Modulation matrix"));
        Dimension size = new Dimension(575, 390);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
    }

    public void modulationMatrixUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JModulationMatrix.this.removeAll();
                JModulationMatrix.this.addAll();
                Skins.setSkin(Skins.currentSkin(), JModulationMatrix.this);
            }
        });
    }

    private void addAll() {
        int rowsAdded = 0;
        for (ModulationMatrixRow modulationMatrixRow : this.modulationMatrix.getModulationConfig(false)) {
            this.add(new JModulationMatrixRow(modulationMatrixRow.source(), modulationMatrixRow.target(), modulationMatrixRow.depth()));
            ++rowsAdded;
        }
        for (int i = rowsAdded; i < 13; ++i) {
            this.add(new JModulationMatrixRow(false));
        }
    }

    private final class JModulationMatrixRow
    extends JPanel {
        private final JComboBox<ModulationSource> sources = new JComboBox<ModulationSource>(ModulationSource.values());
        private final JComboBox<ModulationTarget> targets = new JComboBox<ModulationTarget>(ModulationTarget.values());
        private final JSmallKnob knob = new JSmallKnob();
        private final JButton deleteButton = new JButton("Delete");
        private ModulationSource previousSource;
        private ModulationTarget previousTarget;

        public JModulationMatrixRow(ModulationSource source, ModulationTarget target, Control depth) {
            this(true);
            this.sources.setSelectedItem((Object)source);
            this.targets.setSelectedItem((Object)target);
            this.knob.attachControl(depth);
            this.previousSource = source;
            this.previousTarget = target;
            this.registerHooks();
        }

        public JModulationMatrixRow(boolean skipHooks) {
            this.sources.setSelectedItem(null);
            this.targets.setSelectedItem(null);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.sources);
            this.add(this.knob);
            this.add(this.targets);
            this.add(this.deleteButton);
            this.deleteButton.setMargin(new Insets(0, 2, 0, 2));
            this.deleteButton.setSize(new Dimension(56, 25));
            this.deleteButton.setMaximumSize(this.deleteButton.getSize());
            this.deleteButton.setMinimumSize(this.deleteButton.getSize());
            this.deleteButton.setPreferredSize(this.deleteButton.getSize());
            Dimension size = new Dimension(600, 25);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setSize(size);
            this.sources.setSize(new Dimension(175, 25));
            this.targets.setSize(new Dimension(175, 25));
            if (!skipHooks) {
                this.registerHooks();
            }
        }

        private void registerHooks() {
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JModulationMatrix.this.modulationMatrix.remove((ModulationSource)((Object)JModulationMatrixRow.this.sources.getSelectedItem()), (ModulationTarget)((Object)JModulationMatrixRow.this.targets.getSelectedItem()));
                    JModulationMatrixRow.this.sources.setSelectedItem(null);
                    JModulationMatrixRow.this.targets.setSelectedItem(null);
                }
            });
            this.sources.addActionListener(this::potentiallyUpdateModulationMatrix);
            this.targets.addActionListener(this::potentiallyUpdateModulationMatrix);
            this.sources.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    JModulationMatrixRow.this.sources.removeAllItems();
                    List<ModulationMatrixRow> existingRows = JModulationMatrix.this.modulationMatrix.getModulationConfig(true);
                    ModulationTarget modulationTarget = (ModulationTarget)((Object)JModulationMatrixRow.this.targets.getSelectedItem());
                    block0: for (ModulationSource modulationSource : ModulationSource.values()) {
                        if (modulationTarget != null) {
                            for (ModulationMatrixRow existingRow : existingRows) {
                                if (existingRow.source() != modulationSource || existingRow.target() != modulationTarget) continue;
                                continue block0;
                            }
                        }
                        JModulationMatrixRow.this.sources.addItem(modulationSource);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.targets.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    JModulationMatrixRow.this.targets.removeAllItems();
                    List<ModulationMatrixRow> existingRows = JModulationMatrix.this.modulationMatrix.getModulationConfig(true);
                    ModulationSource modulationSource = (ModulationSource)((Object)JModulationMatrixRow.this.sources.getSelectedItem());
                    block0: for (ModulationTarget modulationTarget : ModulationTarget.values()) {
                        if (modulationSource != null) {
                            for (ModulationMatrixRow existingRow : existingRows) {
                                if (existingRow.source() != modulationSource || existingRow.target() != modulationTarget) continue;
                                continue block0;
                            }
                        }
                        JModulationMatrixRow.this.targets.addItem(modulationTarget);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }

        private void potentiallyUpdateModulationMatrix(ActionEvent ignored) {
            ModulationSource source = (ModulationSource)((Object)this.sources.getSelectedItem());
            ModulationTarget target = (ModulationTarget)((Object)this.targets.getSelectedItem());
            if (source != null && target != null) {
                JModulationMatrix.this.modulationMatrix.remove(this.previousSource, this.previousTarget);
                Control control = JModulationMatrix.this.modulationMatrix.add(source, target);
                this.knob.attachControl(control);
                this.previousSource = source;
                this.previousTarget = target;
            }
        }
    }
}

