/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import net.jevring.frequencies.v2.ui.JOscilloscope;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;

public class JMiniWaveformDisplay
extends JComponent
implements JOscilloscope,
JSkinnable {
    private volatile Skin skin = Skins.BLUE_RED;
    private volatile Polygon polygon = null;

    @Override
    public void newChunk(double[] chunk) {
        int width = this.getWidth();
        int height = this.getHeight();
        int middleByHeight = height / 2;
        Polygon p = new Polygon();
        int x = 5;
        int maxXAxis = width - 10;
        int scale = middleByHeight - 10;
        for (int i = 0; i < chunk.length; i += 2) {
            double datum = chunk[i];
            int scaledValue = (int)(datum * (double)scale);
            p.addPoint(x, middleByHeight - scaledValue);
            if (++x >= maxXAxis) break;
        }
        this.polygon = p;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int middleByHeight = height / 2;
        if (this.isOpaque()) {
            g.setColor(this.skin.background());
            g.fillRect(0, 0, width, height);
        }
        g.setColor(this.skin.foreground());
        g.drawLine(5, 5, 5, height - 5);
        g.drawLine(5, middleByHeight, width - 10, middleByHeight);
        if (this.polygon != null) {
            g.setColor(Color.green);
            g.drawPolyline(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
            g.setColor(Color.red);
            for (int i = 0; i < this.polygon.npoints; ++i) {
                g.drawRect(this.polygon.xpoints[i], this.polygon.ypoints[i], 1, 1);
            }
        }
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.repaint();
    }
}

