/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;

public class JLight
extends JComponent
implements JSkinnable {
    private volatile Skin skin = Skins.currentSkin();
    private volatile boolean on;
    private volatile Color color;

    public JLight() {
        Dimension size = new Dimension(12, 12);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.skin.background());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(Color.darkGray);
        int xCenter = this.getWidth() / 2;
        int yCenter = this.getHeight() / 2;
        g.fillOval(xCenter - 6, yCenter - 6, 12, 12);
        if (this.on) {
            g.setColor(this.color);
            g.fillOval(xCenter - 4, yCenter - 4, 8, 8);
        }
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.setOpaque(skin.opaque());
    }

    public void on(Color color) {
        this.color = color;
        this.on = true;
        this.repaint();
    }

    public void off() {
        this.on = false;
        this.repaint();
    }
}

