/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;
import net.jevring.frequencies.v2.modulation.SidedDepth;
import net.jevring.frequencies.v2.ui.FontSupport;
import net.jevring.frequencies.v2.ui.JControlChangeMappable;
import net.jevring.frequencies.v2.ui.JModulationDisplay;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JKnob
extends JPanel
implements JControlChangeMappable,
JModulationDisplay,
JSkinnable {
    private static final boolean DOT_INDICATOR = false;
    private static final int INDICATOR_DEGREE_OFFSET_AT_START = 135;
    private static final double SENSITIVITY = 250.0;
    private static final int DIAMETER = 40;
    private final Control control;
    private final String label;
    private final ValueFormatter valueFormat;
    private volatile int mouseClickedLocation = -1;
    private volatile double valueAtMouseClick = -1.0;
    private volatile SidedDepth modulationDepth;
    private volatile double modulationValue;
    private volatile Skin skin = Skins.defaultSkin();
    private volatile boolean disabled = false;

    public JKnob(String label, Control control) {
        this(label, control, ValueFormatter.PURE);
    }

    public JKnob(String label, Control control, ValueFormatter valueFormat) {
        this(label, control, valueFormat, 50);
    }

    public JKnob(String label, final Control control, ValueFormatter valueFormat, int width) {
        this.valueFormat = valueFormat;
        this.setDoubleBuffered(true);
        int height = 85;
        if (label == null) {
            height = 65;
        }
        this.setAllSizes(width, height);
        this.label = label;
        this.control = Objects.requireNonNull(control);
        this.control.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                JKnob.this.repaint();
            }
        });
        ToolTipManager.sharedInstance().setInitialDelay(150);
        this.updateTooltip();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    JKnob.this.requestFocus();
                    JKnob.this.mouseClickedLocation = e.getY();
                    JKnob.this.valueAtMouseClick = control.getCurrentValue();
                } else {
                    JKnob.this.mouseClickedLocation = -1;
                    JKnob.this.valueAtMouseClick = -1.0;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JKnob.this.mouseClickedLocation != -1) {
                    int distance = JKnob.this.mouseClickedLocation - e.getY();
                    double domainChange = distance > 0 ? Interpolation.linear(0.0, 250.0, distance, 0.0, control.getMax()) : Interpolation.linear(250.0, 0.0, distance, control.getMax(), 0.0);
                    double newValue = JKnob.this.valueAtMouseClick + domainChange;
                    double domainValue = Clamp.clamp(newValue, control.getMin(), control.getMax());
                    control.set(control.getMin(), domainValue, control.getMax(), JKnob.this);
                    JKnob.this.updateTooltip();
                    JKnob.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    JKnob.this.increment();
                } else if (e.getKeyCode() == 40) {
                    JKnob.this.decrement();
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    JKnob.this.increment();
                } else {
                    JKnob.this.decrement();
                }
            }
        });
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.updateTooltip();
        this.repaint();
    }

    public void setAllSizes(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
    }

    private void increment() {
        if (this.control.isStepped()) {
            this.control.setRaw(this.control.getCurrentValue() + 1.0);
        } else {
            this.control.setRaw(BigDecimal.valueOf(this.control.getCurrentValue()).add(new BigDecimal("0.1")).setScale(1, RoundingMode.HALF_UP).doubleValue());
        }
        this.updateTooltip();
        this.repaint();
    }

    private void decrement() {
        if (this.control.isStepped()) {
            this.control.setRaw(this.control.getCurrentValue() - 1.0);
        } else {
            this.control.setRaw(BigDecimal.valueOf(this.control.getCurrentValue()).subtract(new BigDecimal("0.1")).setScale(1, RoundingMode.HALF_UP).doubleValue());
        }
        this.updateTooltip();
        this.repaint();
    }

    private void updateTooltip() {
        if (this.disabled) {
            this.setToolTipText("This control is disabled. I'm working on fixing it.");
        } else {
            this.setToolTipText(String.format(Locale.US, "%s: Min: %.2f, Value: %.2f, Max: %.2f, Curve: %s", this.label == null ? "" : this.label, this.control.getMin(), this.control.getCurrentValue(), this.control.getMax(), this.control.getCurve().getClass().getSimpleName()));
        }
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.repaint();
    }

    @Override
    public void currentModulation(SidedDepth depth, double value) {
        if (Objects.equals(depth, this.modulationDepth) && value == this.modulationValue) {
            return;
        }
        this.modulationDepth = depth;
        this.modulationValue = value;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font(FontSupport.PREFERRED_FONT, 0, 12));
        FontMetrics fontMetrics = g.getFontMetrics();
        int stringHeight = fontMetrics.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.skin.background());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int width = this.getWidth();
        int xOffset = (width - 40) / 2;
        int yOffset = this.label != null ? 6 + stringHeight : 6;
        if (this.modulationDepth != null) {
            double maxDegreesCoverageForModulationRange = 270.0;
            int arcStartInDegrees = (int)Interpolation.linear(this.control.getMin(), this.control.getMax(), this.control.getCurrentValue(), 235.0, -45.0);
            double negativeRangeProportion = this.modulationDepth.negative() / 2.0;
            double positiveRangeProportion = this.modulationDepth.positive() / 2.0;
            int negativeRange = (int)(maxDegreesCoverageForModulationRange * negativeRangeProportion);
            int positiveRange = (int)(maxDegreesCoverageForModulationRange * positiveRangeProportion);
            g.setColor(this.skin.modulationRange());
            int rangeXOffset = xOffset - 6;
            int rangeYOffset = yOffset - 6;
            g.fillArc(rangeXOffset, rangeYOffset, 52, 52, arcStartInDegrees, -negativeRange);
            g.fillArc(rangeXOffset, rangeYOffset, 52, 52, arcStartInDegrees, -positiveRange);
            if (this.modulationValue != 0.0) {
                g.setColor(this.skin.modulationValue());
                if (this.modulationValue < 0.0) {
                    double activeProportion = this.modulationValue / this.modulationDepth.negative();
                    int value = (int)((double)negativeRange * activeProportion);
                    g.fillArc(rangeXOffset + 3, rangeYOffset + 3, 46, 46, arcStartInDegrees, -value);
                } else {
                    double activeProportion = this.modulationValue / this.modulationDepth.positive();
                    int value = (int)((double)positiveRange * activeProportion);
                    g.fillArc(rangeXOffset + 3, rangeYOffset + 3, 46, 46, arcStartInDegrees, -value);
                }
            }
        }
        if (this.disabled) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(this.skin.knobBackground());
        }
        g.fillOval(xOffset, yOffset, 40, 40);
        double currentValueRotationInDegrees = Interpolation.linear(this.control.getMin(), this.control.getMax(), this.control.getCurrentValue(), 0.0, 270.0);
        double radiansPerDegree = Math.PI / 180;
        double theta = (currentValueRotationInDegrees + 135.0) * radiansPerDegree;
        double radius = 20.0;
        double endX = (double)xOffset + (radius + radius * Math.cos(theta));
        double endY = (double)yOffset + (radius + radius * Math.sin(theta));
        double centerX = (double)xOffset + radius;
        double centerY = (double)yOffset + radius;
        double lengthX = endX - centerX;
        double lengthY = endY - centerY;
        double segmentStartX = centerX + lengthX * 0.6;
        double segmentStartY = centerY + lengthY * 0.6;
        double segmentEndX = centerX + lengthX * 0.9;
        double segmentEndY = centerY + lengthY * 0.9;
        g.setColor(this.skin.knobForeground());
        g2.setStroke(new BasicStroke(3.0f, 1, 1));
        g.drawLine((int)Math.round(segmentStartX), (int)Math.round(segmentStartY), (int)Math.round(segmentEndX), (int)Math.round(segmentEndY));
        int mid = 20;
        g.setColor(this.skin.text());
        if (this.valueFormat != null) {
            String value = this.valueFormat.format(this.control.getCurrentValue());
            int valueWidth = fontMetrics.stringWidth(value);
            int valueX = mid - valueWidth / 2;
            g.drawString(value, xOffset + valueX, yOffset + 40 + stringHeight);
        }
        if (this.label != null) {
            int labelWidth = fontMetrics.stringWidth(this.label);
            int labelX = mid - labelWidth / 2;
            g.drawString(this.label, xOffset + labelX, stringHeight);
        }
    }

    @Override
    public String getControl() {
        return this.control.getKey();
    }
}

