/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.jevring.frequencies.v2.input.KeyTimings;

public class JInstantPad
extends JComponent {
    private final Color deactivated = Color.LIGHT_GRAY;
    private final Color hit = Color.GREEN;
    private volatile boolean on = false;

    public JInstantPad(final KeyTimings keyTimings, final int key) {
        this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        Dimension size = new Dimension(60, 60);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) == 1024) {
                    JInstantPad.this.on = true;
                    keyTimings.down(key, 127);
                    JInstantPad.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) == 1024) {
                    JInstantPad.this.on = false;
                    keyTimings.up(key);
                    JInstantPad.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JInstantPad.this.on = true;
                keyTimings.down(key, 127);
                JInstantPad.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JInstantPad.this.on = false;
                keyTimings.up(key);
                JInstantPad.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.deactivated);
        g.fillRect(0, 0, 60, 60);
        if (this.on) {
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint(new Point2D.Float(30.0f, 30.0f), 20.0f, new float[]{0.5f, 1.0f}, new Color[]{this.hit, this.deactivated});
            ((Graphics2D)g).setPaint(radialGradientPaint);
            g.fillOval(0, 0, 60, 60);
        }
    }
}

