/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.input.InputMode;
import net.jevring.frequencies.v2.ui.Bindings;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JInputPanel
extends JPanel {
    public JInputPanel(Controls controls) {
        final JCheckBox inputModeSelector = new JCheckBox("Polyphonic");
        final DiscreteControl inputModeControl = controls.getDiscreteControl("input-mode");
        inputModeControl.addListener(new DiscreteControlListener<String>(){

            @Override
            public void valueChanged(String value, Object source) {
                if (source != inputModeSelector) {
                    inputModeSelector.setSelected(InputMode.POLYPHONIC.name().equals(value));
                }
            }
        });
        inputModeSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                inputModeControl.set(e.getStateChange() == 1 ? InputMode.POLYPHONIC.name() : InputMode.MONOPHONIC.name(), inputModeSelector);
            }
        });
        JKnob glideLengthKnob = new JKnob("Glide", controls.getControl("glide-length"), ValueFormatter.SECONDS);
        JCheckBox velocitySensitivity = new JCheckBox("Velocity");
        Bindings.bind(velocitySensitivity, controls.getBooleanControl("velocity-sensitive-keys"));
        JCheckBox legato = new JCheckBox("Legato");
        Bindings.bind(legato, controls.getBooleanControl("legato"));
        glideLengthKnob.setAlignmentX(0.0f);
        velocitySensitivity.setAlignmentX(0.0f);
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, "Input", 1, 2));
        this.setAlignmentX(0.0f);
        this.add((Component)glideLengthKnob, GridBadLayoutUtils.gbc(0, 0, 1, 3, 1.0, 2.0));
        this.add((Component)inputModeSelector, GridBadLayoutUtils.gbc(1, 0, 1, 1, 1.0, 2.0));
        this.add((Component)velocitySensitivity, GridBadLayoutUtils.gbc(1, 1, 1, 1, 1.0, 2.0));
        this.add((Component)legato, GridBadLayoutUtils.gbc(1, 2, 1, 1, 1.0, 2.0));
    }
}

