/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Envelopes;
import net.jevring.frequencies.v2.envelopes.LoopingEnvelope;
import net.jevring.frequencies.v2.ui.Bindings;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JControlledComboBox;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JEnvelopePanel
extends JPanel {
    public JEnvelopePanel(Controls controls, Envelopes envelopes, String prefix) {
        DiscreteControl envelopeType = controls.getDiscreteControl(prefix + "-envelope-type");
        JControlledComboBox envelopeSelector = new JControlledComboBox(envelopeType, 180);
        JKnob volumeAttackKnob = new JKnob("Attack", controls.getControl(prefix + "-envelope-attack"), ValueFormatter.MILLISECONDS);
        JKnob volumeDecayKnob = new JKnob("Decay", controls.getControl(prefix + "-envelope-decay"), ValueFormatter.MILLISECONDS);
        JKnob volumeSustainKnob = new JKnob("Sustain", controls.getControl(prefix + "-envelope-sustain"), ValueFormatter.PERCENT);
        JKnob volumeReleaseKnob = new JKnob("Release", controls.getControl(prefix + "-envelope-release"), ValueFormatter.MILLISECONDS);
        final JCheckBox loop = new JCheckBox("Loop", false);
        Bindings.bind(loop, controls.getBooleanControl(prefix + "-envelope-loop"));
        envelopeType.mapping(envelopes::create).addListener(new DiscreteControlListener<Envelope>(){

            @Override
            public void valueChanged(Envelope envelope, Object source) {
                if (envelope instanceof LoopingEnvelope) {
                    loop.setEnabled(true);
                    loop.setToolTipText(null);
                } else {
                    loop.setEnabled(false);
                    loop.setToolTipText("Not supported for this envelope");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        String title = prefix + " envelope";
        title = Character.toUpperCase(title.charAt(0)) + title.substring(1);
        this.setBorder(new TitledBorder(null, title, 1, 2));
        this.setAlignmentX(0.0f);
        this.add((Component)envelopeSelector, GridBadLayoutUtils.gbc(0, 0, 3, 1, 1.0, 2.0));
        this.add((Component)loop, GridBadLayoutUtils.gbc(3, 0, 1, 1, 1.0, 2.0));
        this.add((Component)volumeAttackKnob, GridBadLayoutUtils.gbc(0, 1, 1, 1, 1.0, 2.0));
        this.add((Component)volumeDecayKnob, GridBadLayoutUtils.gbc(1, 1, 1, 1, 1.0, 2.0));
        this.add((Component)volumeSustainKnob, GridBadLayoutUtils.gbc(2, 1, 1, 1, 1.0, 2.0));
        this.add((Component)volumeReleaseKnob, GridBadLayoutUtils.gbc(3, 1, 1, 1, 1.0, 2.0));
    }
}

