/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.tools;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jevring.frequencies.v2.math.Interpolation;

public class PresetMigration {
    public static void main(String[] args) throws IOException {
        Files.walkFileTree(Path.of("src", "main", "resources", "presets"), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Pattern p = Pattern.compile("(.*)-duty-cycle,0.000000,1.000000,(\\d\\.\\d+)(,Linear)");
                List<String> lines = Files.readAllLines(file);
                boolean writeBack = false;
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    Matcher matcher = p.matcher(line);
                    if (!matcher.matches()) continue;
                    double newValue = Interpolation.linear(0.0, 1.0, Double.parseDouble(matcher.group(2)), -1.0, 1.0);
                    lines.set(i, matcher.group(1) + "-wave-shape,-1,1," + String.format(Locale.US, "%f", newValue) + matcher.group(3));
                    writeBack = true;
                }
                if (writeBack) {
                    Files.writeString(file, (CharSequence)String.join((CharSequence)"\n", lines), new OpenOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

