/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.output;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Device {
    private final AudioFormat audioFormat;
    private final String description;
    private final Mixer mixer;
    private SourceDataLine sourceDataLine;

    private Device(AudioFormat audioFormat, String description, Mixer mixer) {
        this.audioFormat = audioFormat;
        this.description = description;
        this.mixer = mixer;
    }

    public String describe() {
        return this.description;
    }

    public SourceDataLine open() throws LineUnavailableException {
        this.sourceDataLine = this.mixer == null ? AudioSystem.getSourceDataLine(this.audioFormat) : (SourceDataLine)this.mixer.getLine(new DataLine.Info(SourceDataLine.class, this.audioFormat));
        if (this.sourceDataLine == null) {
            throw new IllegalStateException("Could not get line for format " + this.audioFormat);
        }
        this.sourceDataLine.open(this.audioFormat, (int)((float)(this.audioFormat.getFrameSize() * this.audioFormat.getChannels()) * this.audioFormat.getSampleRate() * 2.0f));
        this.sourceDataLine.start();
        return this.sourceDataLine;
    }

    public void close() {
        if (this.sourceDataLine == null || !this.sourceDataLine.isOpen()) {
            throw new IllegalStateException("You can't close a line that isn't open");
        }
        this.sourceDataLine.close();
    }

    public static List<Device> supportedSoundDevices(AudioFormat format) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        ArrayList<Device> supportedDevices = new ArrayList<Device>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(info)) continue;
            supportedDevices.add(new Device(format, mixerInfo.toString(), mixer));
        }
        supportedDevices.add(Device.defaultDevice(format));
        return supportedDevices;
    }

    public static Device defaultDevice(AudioFormat format) {
        return new Device(format, "Default", null);
    }
}

