/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.oscillators;

import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.util.SignalEnergyAdder;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class Oscillator {
    public static final int QUANTIZATION_DISABLED = 16;
    private static final int PER_OSCILLATOR_UNISON_VOICES = 32;
    private static final double OCTAVE_MODULATION_RANGE = 4.0;
    private static final double DETUNE_MODULATION_RANGE = 12.0;
    private static final double QUANTIZATION_STEPS_MODULATION_RANGE = 16.0;
    private static final double WAVEFORM_VARIATION_MODULATION_RANGE = 3.0;
    private final PerOscillatorUnisonVoice[] voices = new PerOscillatorUnisonVoice[32];
    private final double sampleRate;
    private volatile Waveform waveform;
    private volatile double octaveOffset = 0.0;
    private volatile double semitoneOffset = 0.0;
    private volatile double phaseShift = 0.0;
    private volatile double waveShape = 0.0;
    private volatile int quantizationSteps = 16;
    private volatile double waveformVariation = 2.0;
    private volatile int perOscillatorUnisonVoices = 1;
    private volatile double perOscillatorUnisonDetuneSemiTones = 1.0;
    private volatile double frequencyModulationModulationRange = 2.0;
    private volatile double pitchBendModulationRange = 2.0;

    public Oscillator(double sampleRate) {
        this.sampleRate = sampleRate;
        for (int i = 0; i < 32; ++i) {
            double phaseOffset = Math.random() * 0.1;
            if (i == 16) {
                phaseOffset = 0.0;
            }
            this.voices[i] = new PerOscillatorUnisonVoice(phaseOffset);
        }
    }

    public Waveform getWaveform() {
        return this.waveform;
    }

    public void setWaveform(Waveform waveform) {
        this.waveform = waveform;
        this.reset();
    }

    public void setOctaveOffset(double octaveOffset) {
        this.octaveOffset = octaveOffset;
    }

    public void setSemitoneOffset(double semitoneOffset) {
        this.semitoneOffset = semitoneOffset;
    }

    public void setPhaseShift(double phaseShift) {
        this.phaseShift = phaseShift;
    }

    public void setWaveShape(double waveShape) {
        this.waveShape = waveShape;
    }

    public void setQuantizationSteps(int quantizationSteps) {
        this.quantizationSteps = quantizationSteps;
    }

    public void setWaveformVariation(double waveformVariation) {
        this.waveformVariation = waveformVariation;
    }

    public void setPerOscillatorUnisonVoices(int perOscillatorUnisonVoices) {
        this.perOscillatorUnisonVoices = Math.min(perOscillatorUnisonVoices, 32);
    }

    public void setPerOscillatorUnisonDetuneSemiTones(double perOscillatorUnisonDetuneSemiTones) {
        this.perOscillatorUnisonDetuneSemiTones = perOscillatorUnisonDetuneSemiTones;
    }

    public void setFrequencyModulationModulationRange(double frequencyModulationModulationRange) {
        this.frequencyModulationModulationRange = frequencyModulationModulationRange;
    }

    public void setPitchBendModulationRange(double pitchBendModulationRange) {
        this.pitchBendModulationRange = pitchBendModulationRange;
    }

    public double[] generateSamples(int samplesToGenerate, double frequency, double[] frequencyModulation, double[] waveShapeModulation, double[] pitchBendModulation, double[] phaseShiftModulation, double[] octaveOffsetModulation, double[] semitoneOffsetModulation, double[] quantizationStepModulation, double[] waveformVariationModulation) {
        double uv = this.perOscillatorUnisonVoices / 2;
        if (this.perOscillatorUnisonVoices % 2 == 0) {
            uv -= 0.5;
        }
        SignalEnergyAdder output = new SignalEnergyAdder(this.perOscillatorUnisonVoices, samplesToGenerate);
        for (double d = -uv; d <= uv; d += 1.0) {
            int voiceIndex = (int)(16L + Math.round(d));
            PerOscillatorUnisonVoice voice = this.voices[voiceIndex];
            double unisonFrequency = frequency * Math.pow(2.0, d * (this.perOscillatorUnisonDetuneSemiTones / (double)this.perOscillatorUnisonVoices) / 12.0);
            double[] perOscillatorVoiceSamples = this.generateSamples(voice, samplesToGenerate, unisonFrequency, frequencyModulation, waveShapeModulation, pitchBendModulation, phaseShiftModulation, octaveOffsetModulation, semitoneOffsetModulation, quantizationStepModulation, waveformVariationModulation);
            output.add(perOscillatorVoiceSamples);
        }
        return output.getOutput();
    }

    private double[] generateSamples(PerOscillatorUnisonVoice voice, int samplesToGenerate, double frequency, double[] frequencyModulation, double[] waveShapeModulation, double[] pitchBendModulation, double[] phaseShiftModulation, double[] octaveOffsetModulation, double[] semitoneOffsetModulation, double[] quantizationStepModulation, double[] waveformVariationModulation) {
        double[] samples = new double[samplesToGenerate];
        if (frequency == 0.0) {
            return samples;
        }
        for (int i = 0; i < samplesToGenerate; ++i) {
            double octaveMultiplier = Math.pow(2.0, this.octaveOffset + octaveOffsetModulation[i] * 4.0);
            double semitoneMultiplier = Math.pow(2.0, (this.semitoneOffset + semitoneOffsetModulation[i] * 12.0) / 12.0);
            double frequencyModulationMultiplier = Math.pow(2.0, frequencyModulation[i] * this.frequencyModulationModulationRange / 12.0);
            double pitchBendMultiplier = Math.pow(2.0, pitchBendModulation[i] * this.pitchBendModulationRange / 12.0);
            double frequencyMultiplier = octaveMultiplier * semitoneMultiplier * frequencyModulationMultiplier * pitchBendMultiplier;
            double samplesPerCycle = this.sampleRate / (frequency * frequencyMultiplier);
            double stepSizeInPercent = 1.0 / samplesPerCycle;
            voice.cycleProgress += stepSizeInPercent;
            if (voice.cycleProgress > 1.0) {
                voice.oddCycle = !voice.oddCycle;
                voice.cycleProgress %= 1.0;
            }
            int modulatedQuantizationSteps = (int)Clamp.clamp((double)this.quantizationSteps + quantizationStepModulation[i] * 16.0, 1.0, 16.0);
            double modulatedWaveformVariation = Clamp.clamp(this.waveformVariation + waveformVariationModulation[i] * 3.0, 0.0, 3.0);
            double phaseShiftedCycleProgress = (voice.cycleProgress + voice.phaseOffset + this.phaseShift + phaseShiftModulation[i]) % 1.0;
            double modulatedWaveShape = this.waveShape + waveShapeModulation[i];
            samples[i] = this.waveform.valueAt(phaseShiftedCycleProgress, modulatedWaveShape, voice.oddCycle, modulatedQuantizationSteps, modulatedWaveformVariation);
        }
        return samples;
    }

    public void reset() {
        for (PerOscillatorUnisonVoice voice : this.voices) {
            voice.cycleProgress = 0.0;
            voice.oddCycle = false;
        }
    }

    private static final class PerOscillatorUnisonVoice {
        private double cycleProgress = 0.0;
        private boolean oddCycle = false;
        private final double phaseOffset;

        private PerOscillatorUnisonVoice(double phaseOffset) {
            this.phaseOffset = phaseOffset;
        }
    }
}

