/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.oscillators;

import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.QuantizedWaveform;
import net.jevring.frequencies.v2.waveforms.VariableWaveForm;

public class ControlledOscillator
extends Oscillator {
    public ControlledOscillator(String oscillatorControlPrefix, Controls controls, double sampleRate, boolean generatesSound) {
        super(sampleRate);
        this.setWaveform(new QuantizedWaveform(new VariableWaveForm()));
        controls.getControl(oscillatorControlPrefix + "-wave-shape").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double waveShape, double max, Object source) {
                ControlledOscillator.this.setWaveShape(waveShape);
            }
        });
        controls.getControl(oscillatorControlPrefix + "-quantization-steps").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double value, double max, Object source) {
                ControlledOscillator.this.setQuantizationSteps((int)value);
            }
        });
        controls.getControl(oscillatorControlPrefix + "-variable-waveform").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double value, double max, Object source) {
                ControlledOscillator.this.setWaveformVariation(value);
            }
        });
        if (generatesSound) {
            controls.getControl(oscillatorControlPrefix + "-phase-shift").addListener(new ControlListener(){

                @Override
                public void valueChanged(double min, double phaseShift, double max, Object source) {
                    ControlledOscillator.this.setPhaseShift(phaseShift);
                }
            });
            controls.getControl(oscillatorControlPrefix + "-octave-offset").addListener(new ControlListener(){

                @Override
                public void valueChanged(double min, double octaveOffset, double max, Object source) {
                    ControlledOscillator.this.setOctaveOffset(octaveOffset);
                }
            });
            controls.getControl(oscillatorControlPrefix + "-detune-semi-tones").addListener(new ControlListener(){

                @Override
                public void valueChanged(double min, double detuneSemitones, double max, Object source) {
                    ControlledOscillator.this.setSemitoneOffset(detuneSemitones);
                }
            });
            controls.getControl(oscillatorControlPrefix + "-unison-detune-semi-tones").addListener(new ControlListener(){

                @Override
                public void valueChanged(double min, double detuneSemitones, double max, Object source) {
                    ControlledOscillator.this.setPerOscillatorUnisonDetuneSemiTones(detuneSemitones);
                }
            });
            controls.getControl(oscillatorControlPrefix + "-unison-voices").addListener(new ControlListener(){

                @Override
                public void valueChanged(double min, double newValue, double max, Object source) {
                    ControlledOscillator.this.setPerOscillatorUnisonVoices((int)newValue);
                }
            });
        }
    }
}

