/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modulation.matrix;

public enum ModulationSource {
    LFO1(true),
    LFO1_POSITIVE(false),
    LFO2(true),
    LFO2_POSITIVE(false),
    LFO3(true),
    LFO3_POSITIVE(false),
    SAMPLE_AND_HOLD(true),
    SAMPLE_AND_HOLD_POSITIVE(false),
    VELOCITY(false),
    PITCH_BEND(true),
    RANDOM_NOISE(true),
    FILTER_ENVELOPE(false),
    KEYBOARD_TRACKING(false),
    AMPLIFIER_ENVELOPE(false),
    MODULATION_ENVELOPE(false);

    private final boolean bipolar;

    private ModulationSource(boolean bipolar) {
        this.bipolar = bipolar;
    }

    public boolean isBipolar() {
        return this.bipolar;
    }

    public String toString() {
        if (this == LFO1_POSITIVE) {
            return "LFO1+";
        }
        if (this == LFO2_POSITIVE) {
            return "LFO2+";
        }
        if (this == LFO3_POSITIVE) {
            return "LFO3+";
        }
        if (this == SAMPLE_AND_HOLD_POSITIVE) {
            return "SAMPLE_AND_HOLD+";
        }
        return super.toString();
    }
}

