/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modulation.matrix;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AdditiveMultiSource;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.modulation.SidedDepth;
import net.jevring.frequencies.v2.modulation.matrix.Connection;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixRow;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;

public class ModulationMatrixVoice {
    private final Map<ModulationSource, Source> sources = new LinkedHashMap<ModulationSource, Source>();
    private final Map<ModulationTarget, Connection> connections = new LinkedHashMap<ModulationTarget, Connection>();

    public void registerSource(ModulationSource modulationSource, Source source) {
        this.sources.put(modulationSource, source);
    }

    public void registerTarget(ModulationTarget modulationTarget, AdditiveMultiSource target) {
        this.connections.put(modulationTarget, new Connection(target));
    }

    public SidedDepth getModulationMaxForTarget(ModulationTarget modulationTarget) {
        Connection connection = this.connections.get((Object)modulationTarget);
        if (connection == null) {
            return null;
        }
        return connection.getSidedDepth();
    }

    public double[] getModulationForTarget(ModulationTarget modulationTarget, int samplesToGenerate, Instruction instruction) {
        Connection connection = this.connections.get((Object)modulationTarget);
        if (connection == null) {
            return new double[samplesToGenerate];
        }
        return connection.generateSamples(samplesToGenerate, instruction);
    }

    public void hardwire(ModulationSource modulationSource, ModulationTarget modulationTarget, Control depth) {
        this.add(modulationSource, modulationTarget, depth, true);
    }

    void add(ModulationSource modulationSource, ModulationTarget modulationTarget, Control modulationDepthControl, boolean hardwired) {
        Source source = this.sources.get((Object)modulationSource);
        Connection connection = this.connections.get((Object)modulationTarget);
        if (connection == null) {
            System.err.println("No target registered for " + modulationTarget);
            return;
        }
        connection.connect(modulationSource, new AttenuverterModule(modulationDepthControl, source), hardwired);
    }

    void remove(ModulationSource modulationSource, ModulationTarget modulationTarget) {
        if (modulationSource == null && modulationTarget == null) {
            return;
        }
        Connection connection = this.connections.get((Object)modulationTarget);
        if (connection != null) {
            connection.disconnect(modulationSource);
        } else {
            System.err.println("Expected target proxy for " + modulationSource + " and " + modulationTarget + " to be present, but it wasn't.");
        }
    }

    void clear() {
        for (Connection connection : this.connections.values()) {
            connection.clear();
        }
    }

    List<ModulationMatrixRow> getModulationConfig(boolean includeHardwired) {
        return this.connections.entrySet().stream().flatMap(entry -> {
            ModulationTarget target = (ModulationTarget)((Object)((Object)entry.getKey()));
            Connection connectionProxy = (Connection)entry.getValue();
            return connectionProxy.getConnections(includeHardwired).entrySet().stream().map(tpe -> new ModulationMatrixRow((ModulationSource)((Object)((Object)((Object)tpe.getKey()))), target, ((AttenuverterModule)tpe.getValue()).getDepth()));
        }).collect(Collectors.toUnmodifiableList());
    }
}

