/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modulation;

import java.util.Locale;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.curves.Linear;

public class SampleAndHold {
    private final Control frequency;
    private final Control slew;
    private final float sampleRate;
    private double[] samples;
    private int samplesRemainingInLastInterval;
    private int slewSamplesRemainingInLastInterval;
    private double randomValueInLastInterval;
    private double previousSlewTick;
    private double lastGeneratedRandomValue;

    public SampleAndHold(Control frequency, Control slew, float sampleRate) {
        this.frequency = frequency;
        this.slew = slew;
        this.sampleRate = sampleRate;
    }

    public double[] getSamples(int samplesToGenerate) {
        if (this.samples == null) {
            this.samples = new double[samplesToGenerate];
            double freq = this.frequency.getCurrentValue();
            if (freq > 0.0) {
                int samplesPerValue = (int)Math.round((double)this.sampleRate / freq);
                double slew = this.slew.getCurrentValue();
                int slewSamplesPerValue = (int)Math.round((double)samplesPerValue * slew);
                double slewTick = this.previousSlewTick;
                double randomValue = this.randomValueInLastInterval;
                int samplesRemainingInInterval = Math.min(this.samplesRemainingInLastInterval, samplesPerValue);
                int slewSamplesRemainingInInterval = Math.min(this.slewSamplesRemainingInLastInterval, slewSamplesPerValue);
                for (int i = 0; i < samplesToGenerate; ++i) {
                    if (samplesRemainingInInterval > 0) {
                        --samplesRemainingInInterval;
                        if (slewSamplesRemainingInInterval > 0) {
                            --slewSamplesRemainingInInterval;
                            randomValue += slewTick;
                        }
                    } else {
                        samplesRemainingInInterval = samplesPerValue;
                        slewSamplesRemainingInInterval = slewSamplesPerValue;
                        double nextValue = this.randomValue();
                        if (slewSamplesRemainingInInterval > 0) {
                            double diff = nextValue - this.lastGeneratedRandomValue;
                            slewTick = diff / (double)slewSamplesPerValue;
                        }
                        randomValue = this.lastGeneratedRandomValue;
                        this.lastGeneratedRandomValue = nextValue;
                    }
                    this.samples[i] = randomValue;
                }
                this.samplesRemainingInLastInterval = samplesRemainingInInterval;
                this.slewSamplesRemainingInLastInterval = slewSamplesRemainingInInterval;
                this.randomValueInLastInterval = randomValue;
                this.previousSlewTick = slewTick;
            }
            return this.samples;
        }
        if (this.samples.length != samplesToGenerate) {
            throw new IllegalArgumentException("Can't call getSamples with a different number of samples to generate between calls to next()");
        }
        return this.samples;
    }

    private double randomValue() {
        return Math.random() * 2.0 - 1.0;
    }

    public void next() {
        this.samples = null;
    }

    public static void main(String[] args) {
        SampleAndHold sampleAndHold = new SampleAndHold(new Control("dummy", 0.0, 25.0, 50.0, new Linear(), false), new Control("dummy", 0.0, 0.5, 1.0, new Linear(), false), 44100.0f);
        int chunkSize = 441;
        for (int i = 0; i <= 44100; i += chunkSize) {
            double[] values;
            for (double d : values = sampleAndHold.getSamples(chunkSize)) {
                System.out.printf(Locale.US, "%f%n", d);
            }
            sampleAndHold.next();
        }
    }
}

