/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import java.util.Arrays;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class PositiveRangeModule
implements Source {
    private final Source source;
    private volatile double[] samples;

    public PositiveRangeModule(Source source) {
        this.source = source;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            this.samples = this.shiftToPositive(this.source.generateSamples(samplesToGenerate, instruction));
        }
        return this.samples;
    }

    private double[] shiftToPositive(double[] samples) {
        return Arrays.stream(samples).map(sample -> (sample + 1.0) / 2.0).toArray();
    }

    @Override
    public void next() {
        this.source.next();
        this.samples = null;
    }

    public static void main(String[] args) {
        PositiveRangeModule prm = new PositiveRangeModule(new Source(){

            @Override
            public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
                return new double[]{-1.0, -0.75, -0.5, -0.25, 0.0, 0.25, 0.75, 1.0};
            }

            @Override
            public void next() {
            }
        });
        System.out.println("prm.generateSamples(0, null) = " + Arrays.toString(prm.generateSamples(0, null)));
    }
}

