/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AdditiveMultiSource;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.Oscillator;

public class OscillatorModule
implements Source {
    private final Oscillator oscillator;
    private volatile double[] samples;
    private final AdditiveMultiSource frequencyModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource waveShapeModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource pitchBendModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource phaseShiftModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource octaveOffsetModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource semitoneOffsetModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource quantizationStepModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource waveformVariationModulation = new AdditiveMultiSource();

    public OscillatorModule(Oscillator oscillator) {
        this.oscillator = oscillator;
    }

    public AdditiveMultiSource getFrequencyModulation() {
        return this.frequencyModulation;
    }

    public AdditiveMultiSource getWaveShapeModulation() {
        return this.waveShapeModulation;
    }

    public AdditiveMultiSource getPitchBendModulation() {
        return this.pitchBendModulation;
    }

    public AdditiveMultiSource getPhaseShiftModulation() {
        return this.phaseShiftModulation;
    }

    public AdditiveMultiSource getOctaveOffsetModulation() {
        return this.octaveOffsetModulation;
    }

    public AdditiveMultiSource getSemitoneOffsetModulation() {
        return this.semitoneOffsetModulation;
    }

    public AdditiveMultiSource getQuantizationStepModulation() {
        return this.quantizationStepModulation;
    }

    public AdditiveMultiSource getWaveformVariationModulation() {
        return this.waveformVariationModulation;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            if (instruction == null) {
                this.samples = new double[samplesToGenerate];
            } else {
                if (instruction.isNewInstruction()) {
                    this.oscillator.reset();
                }
                this.samples = this.oscillator.generateSamples(samplesToGenerate, instruction.getFrequency(), this.frequencyModulation.generateSamples(samplesToGenerate, instruction), this.waveShapeModulation.generateSamples(samplesToGenerate, instruction), this.pitchBendModulation.generateSamples(samplesToGenerate, instruction), this.phaseShiftModulation.generateSamples(samplesToGenerate, instruction), this.octaveOffsetModulation.generateSamples(samplesToGenerate, instruction), this.semitoneOffsetModulation.generateSamples(samplesToGenerate, instruction), this.quantizationStepModulation.generateSamples(samplesToGenerate, instruction), this.waveformVariationModulation.generateSamples(samplesToGenerate, instruction));
            }
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.frequencyModulation.next();
        this.waveShapeModulation.next();
        this.pitchBendModulation.next();
        this.phaseShiftModulation.next();
        this.octaveOffsetModulation.next();
        this.semitoneOffsetModulation.next();
        this.quantizationStepModulation.next();
        this.waveformVariationModulation.next();
        this.samples = null;
    }
}

