/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.engine.Voice;
import net.jevring.frequencies.v2.envelopes.ControlledEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelopes;
import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.FilterModule;
import net.jevring.frequencies.v2.modular.KeyboardTrackingModule;
import net.jevring.frequencies.v2.modular.LFOModule;
import net.jevring.frequencies.v2.modular.NoiseModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.PitchBendModule;
import net.jevring.frequencies.v2.modular.PositiveRangeModule;
import net.jevring.frequencies.v2.modular.SampleAndHoldModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.modular.TripleControllerMixer;
import net.jevring.frequencies.v2.modular.VelocityModule;
import net.jevring.frequencies.v2.modulation.SampleAndHold;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixVoice;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;
import net.jevring.frequencies.v2.oscillators.ControlledOscillator;

public class ModularVoice
implements Voice {
    private final Source chain;

    public ModularVoice(float sampleRate, Filters filters, Envelopes envelopes, Controls controls, SampleAndHold sampleAndHold, ModulationMatrixVoice modulationMatrixVoice) {
        ControlledOscillator primaryOscillator = new ControlledOscillator("primary-oscillator", controls, sampleRate, true);
        ControlledOscillator secondaryOscillator = new ControlledOscillator("secondary-oscillator", controls, sampleRate, true);
        ControlledOscillator lfo1 = new ControlledOscillator("lfo1", controls, sampleRate, false);
        ControlledOscillator lfo2 = new ControlledOscillator("lfo2", controls, sampleRate, false);
        ControlledOscillator lfo3 = new ControlledOscillator("lfo3", controls, sampleRate, false);
        LFOModule lfo1Module = new LFOModule(lfo1, controls.getControl("lfo1-frequency"), controls.getBooleanControl("lfo1-key-reset"));
        LFOModule lfo2Module = new LFOModule(lfo2, controls.getControl("lfo2-frequency"), controls.getBooleanControl("lfo2-key-reset"));
        LFOModule lfo3Module = new LFOModule(lfo3, controls.getControl("lfo3-frequency"), controls.getBooleanControl("lfo3-key-reset"));
        PositiveRangeModule lfo1PositiveModule = new PositiveRangeModule(lfo1Module);
        PositiveRangeModule lfo2PositiveModule = new PositiveRangeModule(lfo2Module);
        PositiveRangeModule lfo3PositiveModule = new PositiveRangeModule(lfo3Module);
        VelocityModule velocityModule = new VelocityModule();
        KeyboardTrackingModule keyboardTrackingModule = new KeyboardTrackingModule();
        PitchBendModule pitchBendModule = new PitchBendModule(controls.getControl("pitch-bend"));
        SampleAndHoldModule sampleAndHoldModule = new SampleAndHoldModule(sampleAndHold);
        PositiveRangeModule sampleAndHoldPositiveModule = new PositiveRangeModule(sampleAndHoldModule);
        EnvelopeModule volumeEnvelope = new EnvelopeModule(new ControlledEnvelope(controls, envelopes, "volume"), sampleRate);
        EnvelopeModule filterEnvelope = new EnvelopeModule(new ControlledEnvelope(controls, envelopes, "filter"), sampleRate);
        EnvelopeModule modulationEnvelope = new EnvelopeModule(new ControlledEnvelope(controls, envelopes, "modulation"), sampleRate);
        NoiseModule noise = new NoiseModule();
        OscillatorModule osc1 = new OscillatorModule(primaryOscillator);
        osc1.getPitchBendModulation().connect(new AttenuverterModule(controls.getControl("primary-oscillator-pitch-bend-depth"), pitchBendModule));
        OscillatorModule osc2 = new OscillatorModule(secondaryOscillator);
        osc2.getPitchBendModulation().connect(new AttenuverterModule(controls.getControl("secondary-oscillator-pitch-bend-depth"), pitchBendModule));
        TripleControllerMixer oscillatorMixer = new TripleControllerMixer(noise, osc1, osc2, controls.getControl("noise-oscillator-volume"), controls.getControl("primary-oscillator-volume"), controls.getControl("secondary-oscillator-volume"));
        FilterModule filter = new FilterModule(new ControlledFilter(null, controls, filters));
        filter.setInput(oscillatorMixer);
        ScalingModule applyVolumeEnvelopeToSound = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelopeToSound.setInput(filter);
        applyVolumeEnvelopeToSound.setScaleInput(volumeEnvelope);
        ScalingModule applyVelocityToVolume = new ScalingModule(controls.getBooleanControl("velocity-sensitive-keys"));
        applyVelocityToVolume.setInput(applyVolumeEnvelopeToSound);
        applyVelocityToVolume.setScaleInput(velocityModule);
        this.chain = applyVelocityToVolume;
        modulationMatrixVoice.registerTarget(ModulationTarget.FILTER_CUTOFF_FREQUENCY, filter.getCutoffFrequencyModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.FILTER_RESONANCE, filter.getResonanceFrequencyModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.NOISE_OSCILLATOR_VOLUME, oscillatorMixer.getNoiseModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_FREQUENCY, osc1.getFrequencyModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_WAVE_SHAPE, osc1.getWaveShapeModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_PHASE_SHIFT, osc1.getPhaseShiftModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_QUANTIZATION_STEPS, osc1.getQuantizationStepModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_WAVEFORM_VARIATION, osc1.getWaveformVariationModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_DETUNE, osc1.getSemitoneOffsetModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_OCTAVE, osc1.getOctaveOffsetModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.PRIMARY_OSCILLATOR_VOLUME, oscillatorMixer.getOsc1Modulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_FREQUENCY, osc2.getFrequencyModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_WAVE_SHAPE, osc2.getWaveShapeModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_PHASE_SHIFT, osc2.getPhaseShiftModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_QUANTIZATION_STEPS, osc2.getQuantizationStepModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_WAVEFORM_VARIATION, osc2.getWaveformVariationModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_DETUNE, osc2.getSemitoneOffsetModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_OCTAVE, osc2.getOctaveOffsetModulation());
        modulationMatrixVoice.registerTarget(ModulationTarget.SECONDARY_OSCILLATOR_VOLUME, oscillatorMixer.getOsc2Modulation());
        modulationMatrixVoice.registerSource(ModulationSource.LFO1, lfo1Module);
        modulationMatrixVoice.registerSource(ModulationSource.LFO2, lfo2Module);
        modulationMatrixVoice.registerSource(ModulationSource.LFO3, lfo3Module);
        modulationMatrixVoice.registerSource(ModulationSource.SAMPLE_AND_HOLD, sampleAndHoldModule);
        modulationMatrixVoice.registerSource(ModulationSource.LFO1_POSITIVE, lfo1PositiveModule);
        modulationMatrixVoice.registerSource(ModulationSource.LFO2_POSITIVE, lfo2PositiveModule);
        modulationMatrixVoice.registerSource(ModulationSource.LFO3_POSITIVE, lfo3PositiveModule);
        modulationMatrixVoice.registerSource(ModulationSource.SAMPLE_AND_HOLD_POSITIVE, sampleAndHoldPositiveModule);
        modulationMatrixVoice.registerSource(ModulationSource.FILTER_ENVELOPE, filterEnvelope);
        modulationMatrixVoice.registerSource(ModulationSource.AMPLIFIER_ENVELOPE, volumeEnvelope);
        modulationMatrixVoice.registerSource(ModulationSource.MODULATION_ENVELOPE, modulationEnvelope);
        modulationMatrixVoice.registerSource(ModulationSource.VELOCITY, velocityModule);
        modulationMatrixVoice.registerSource(ModulationSource.RANDOM_NOISE, noise);
        modulationMatrixVoice.registerSource(ModulationSource.KEYBOARD_TRACKING, keyboardTrackingModule);
        modulationMatrixVoice.registerSource(ModulationSource.PITCH_BEND, pitchBendModule);
        modulationMatrixVoice.hardwire(ModulationSource.FILTER_ENVELOPE, ModulationTarget.FILTER_CUTOFF_FREQUENCY, controls.getControl("filter-envelope-depth"));
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }
}

