/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class MixerModule
implements Source {
    private final List<ControlledSource> sources = new ArrayList<ControlledSource>();
    private volatile double[] samples;

    public void add(Source source, Control control) {
        this.sources.add(new ControlledSource(source, control));
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            double[] output = new double[samplesToGenerate];
            for (ControlledSource controlledSource : this.sources) {
                double[] samples = controlledSource.source.generateSamples(samplesToGenerate, instruction);
                double controlScale = controlledSource.control.getCurrentValue();
                for (int i = 0; i < samplesToGenerate; ++i) {
                    int n = i;
                    output[n] = output[n] + samples[i] * controlScale;
                }
            }
            this.samples = output;
        }
        return this.samples;
    }

    @Override
    public void next() {
        for (ControlledSource controlledSource : this.sources) {
            controlledSource.source.next();
        }
        this.samples = null;
    }

    private record ControlledSource(Source source, Control control) {
    }
}

