/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.ControlledOscillator;

public class LFOModule
implements Source {
    private final ControlledOscillator lfo;
    private final Control frequency;
    private final BooleanControl retrigger;
    private volatile double[] samples;

    public LFOModule(ControlledOscillator lfo, Control frequency, BooleanControl retrigger) {
        this.lfo = lfo;
        this.frequency = frequency;
        this.retrigger = retrigger;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            if (instruction != null && instruction.isNewInstruction() && this.retrigger.get()) {
                this.lfo.reset();
            }
            double[] zeroes = new double[samplesToGenerate];
            this.samples = this.lfo.generateSamples(samplesToGenerate, this.frequency.getCurrentValue(), zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes);
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.samples = null;
    }
}

