/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AdditiveMultiSource;
import net.jevring.frequencies.v2.modular.Source;

public class FilterModule
implements Source {
    private final ControlledFilter filter;
    private final AdditiveMultiSource cutoffFrequencyModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource resonanceFrequencyModulation = new AdditiveMultiSource();
    private volatile Source input = Source.DISCONNECTED;
    private volatile double[] samples;

    public FilterModule(ControlledFilter filter) {
        this.filter = filter;
    }

    public AdditiveMultiSource getCutoffFrequencyModulation() {
        return this.cutoffFrequencyModulation;
    }

    public AdditiveMultiSource getResonanceFrequencyModulation() {
        return this.resonanceFrequencyModulation;
    }

    public void setInput(Source input) {
        this.input = input;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            if (instruction != null && instruction.isNewInstruction()) {
                this.filter.reset();
            }
            this.samples = this.filter.apply(this.input.generateSamples(samplesToGenerate, instruction), this.cutoffFrequencyModulation.generateSamples(samplesToGenerate, instruction), this.resonanceFrequencyModulation.generateSamples(samplesToGenerate, instruction));
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.input.next();
        this.cutoffFrequencyModulation.next();
        this.resonanceFrequencyModulation.next();
        this.samples = null;
    }
}

