/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class EnvelopeModule
implements Source {
    private final Envelope envelope;
    private final double sampleRate;
    private volatile double[] samples;

    public EnvelopeModule(Envelope envelope, double sampleRate) {
        this.envelope = envelope;
        this.sampleRate = sampleRate;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            if (instruction == null) {
                this.samples = new double[samplesToGenerate];
            } else {
                if (instruction.isNewInstruction()) {
                    this.envelope.reset();
                }
                this.samples = this.envelope.levels(instruction.getNanosecondsActivated(), instruction.getNanosecondsDeactivated(), samplesToGenerate, this.sampleRate);
            }
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.samples = null;
    }
}

