/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.math;

public class Interpolation {
    public static double linear(double sourceStart, double sourceEnd, double sourceValue, double targetStart, double targetEnd) {
        double sourceRange = sourceEnd - sourceStart;
        double valueInSourceRange = sourceValue - sourceStart;
        double proportion = valueInSourceRange / sourceRange;
        double targetRange = targetEnd - targetStart;
        double targetChange = proportion * targetRange;
        return targetStart + targetChange;
    }

    public static double exponential(double sourceStart, double sourceEnd, double sourceValue, double targetStart, double targetEnd) {
        double sourceRange = sourceEnd - sourceStart;
        double valueInSourceRange = sourceValue - sourceStart;
        double proportion = valueInSourceRange / sourceRange;
        double targetRange = targetEnd - targetStart;
        double targetChange = targetRange * Math.pow(proportion, 2.0);
        return targetStart + targetChange;
    }

    public static double logarithmic(double sourceStart, double sourceEnd, double sourceValue, double targetStart, double targetEnd) {
        double in = Interpolation.linear(sourceStart, sourceEnd, sourceValue, 0.01, 10.0);
        double logIn = Math.log10(in);
        return Interpolation.linear(-2.0, 1.0, logIn, targetStart, targetEnd);
    }
}

