/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.tempo;

import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.input.Sequencer;
import net.jevring.frequencies.v2.input.tempo.AbstractTempoSource;

public class MainLoopTempoSource
extends AbstractTempoSource {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private volatile boolean running;
    private volatile Thread thread;
    private volatile double tempo = 120.0;

    public MainLoopTempoSource(Controls controls) {
        controls.getControl("tempo").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                MainLoopTempoSource.this.tempo = newValue;
            }
        });
    }

    private void loop() {
        long previousNanos = System.nanoTime();
        while (this.running) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long nowNanos = System.nanoTime();
            long elapsedNanos = nowNanos - previousNanos;
            try {
                double secondsPerBeat = 60.0 / this.tempo;
                long nanosPerBeat = (long)(secondsPerBeat * 1.0E9);
                long nanosPerTick = nanosPerBeat / 24L;
                if (elapsedNanos < nanosPerTick) continue;
                for (Sequencer sequencer : this.sequencers) {
                    sequencer.nextTick();
                }
                previousNanos = nowNanos;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("Already running");
        }
        this.running = true;
        this.thread = new Thread(this::loop, "main-loop-tempo-source");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("Not running");
        }
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }
}

