/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.sequencer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.input.AbstractMonophonicKeySequencer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.MonophonicSequencerStep;
import net.jevring.frequencies.v2.input.midi.MidiNoteListener;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;
import net.jevring.frequencies.v2.input.sequencer.ControlledSequencerStep;

public class StepSequencer
extends AbstractMonophonicKeySequencer<ControlledSequencerStep> {
    private final List<Integer> currentlyHighlightedSteps = new ArrayList<Integer>();
    private final MidiReceiver midiReceiver;
    private final BooleanControl sequencerListen;
    private final Controls controls;

    public StepSequencer(final MidiReceiver midiReceiver, Controls controls, KeyTimings keyTimings) {
        super((MonophonicSequencerStep[])StepSequencer.sequence(controls), keyTimings, controls);
        this.controls = controls;
        this.midiReceiver = midiReceiver;
        controls.getBooleanControl("sequencer-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean active, Object source) {
                StepSequencer.this.setActive(active);
            }
        });
        controls.getControl("sequencer-steps").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                StepSequencer.this.setSteps((int)newValue);
            }
        });
        this.sequencerListen = controls.getBooleanControl("sequencer-listen");
        this.sequencerListen.addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean listening, Object source) {
                if (listening.booleanValue()) {
                    StepSequencer.this.listenForNotes();
                } else {
                    midiReceiver.stopListening();
                }
            }
        });
    }

    private static ControlledSequencerStep[] sequence(Controls controls) {
        ControlledSequencerStep[] sequence = new ControlledSequencerStep[16];
        for (int step = 0; step < 16; ++step) {
            sequence[step] = new ControlledSequencerStep(step, controls);
        }
        return sequence;
    }

    private void listenForNotes() {
        for (int i = 0; i < this.getSteps(); ++i) {
            this.sequencerVisualizer.visualizedSequencerStep(i, true);
        }
        this.midiReceiver.listen(new MidiNoteListener(){
            private int stepsRecorded = 0;

            @Override
            public void down(int key, int velocity) {
                StepSequencer.this.keyTimings.down(key, velocity);
                int currentStep = this.stepsRecorded++;
                Control stepControl = StepSequencer.this.controls.getControl("sequencer-note-" + currentStep);
                stepControl.set(stepControl.getMin(), key, stepControl.getMax(), this);
                StepSequencer.this.sequencerVisualizer.visualizedSequencerStep(currentStep, false);
                if (this.stepsRecorded == StepSequencer.this.getSteps()) {
                    StepSequencer.this.midiReceiver.stopListening();
                    StepSequencer.this.sequencerListen.set(false, this);
                }
            }

            @Override
            public void up(int key) {
                StepSequencer.this.keyTimings.up(key);
            }
        });
    }

    @Override
    protected void visualizeStep(int step) {
        if (this.currentlyHighlightedSteps.size() > 1) {
            System.out.println("There were currently " + this.currentlyHighlightedSteps.size() + " steps highlighted: " + this.currentlyHighlightedSteps);
        }
        Iterator<Integer> iterator = this.currentlyHighlightedSteps.iterator();
        while (iterator.hasNext()) {
            Integer currentlyHighlightedStep = iterator.next();
            iterator.remove();
            this.sequencerVisualizer.visualizedSequencerStep(currentlyHighlightedStep, false);
        }
        this.currentlyHighlightedSteps.add(step);
        this.sequencerVisualizer.visualizedSequencerStep(step, true);
    }

    @Override
    protected void nextCycle() {
    }

    @Override
    protected void visualizeBeat() {
        this.sequencerVisualizer.visualizedSequencerBeat(this);
    }

    @Override
    protected void setActive(boolean active) {
        super.setActive(active);
        if (this.sequencerVisualizer != null) {
            for (int step = 0; step < 16; ++step) {
                this.sequencerVisualizer.visualizedSequencerStep(step, false);
            }
        }
    }
}

