/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.euclidean;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.input.AbstractMonophonicKeySequencer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.MonophonicSequencerStep;
import net.jevring.frequencies.v2.input.MutableMonophonicSequencerStep;
import net.jevring.frequencies.v2.input.WrappingPolyphonicSequencerStep;

public class EuclideanSequencer
extends AbstractMonophonicKeySequencer<MutableMonophonicSequencerStep> {
    public static final int MAX_STEPS = 32;
    private volatile int innerSteps = 16;
    private volatile int outerSteps = 16;
    private volatile double gate = 0.5;
    private volatile int note = 60;
    private volatile int rotation = 0;

    public EuclideanSequencer(Controls controls, KeyTimings keyTimings) {
        super((MonophonicSequencerStep[])EuclideanSequencer.sequence(), keyTimings, controls);
        controls.getControl("euclidean-sequencer-gate").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double gate, double max, Object source) {
                EuclideanSequencer.this.gate = gate;
                EuclideanSequencer.this.recalculate();
            }
        });
        controls.getControl("euclidean-sequencer-note").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double note, double max, Object source) {
                EuclideanSequencer.this.note = (int)note;
                EuclideanSequencer.this.recalculate();
            }
        });
        controls.getControl("euclidean-sequencer-rotation").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double rotation, double max, Object source) {
                EuclideanSequencer.this.rotation = (int)rotation;
                EuclideanSequencer.this.recalculate();
            }
        });
        controls.getControl("euclidean-sequencer-inner-steps").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double innerSteps, double max, Object source) {
                EuclideanSequencer.this.innerSteps = (int)innerSteps;
                EuclideanSequencer.this.recalculate();
            }
        });
        controls.getControl("euclidean-sequencer-outer-steps").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double outerSteps, double max, Object source) {
                EuclideanSequencer.this.outerSteps = (int)outerSteps;
                EuclideanSequencer.this.recalculate();
            }
        });
        controls.getBooleanControl("euclidean-sequencer-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean active, Object source) {
                EuclideanSequencer.this.setActive(active);
            }
        });
    }

    private void recalculate() {
        boolean wasActive = this.isActive();
        this.setActive(false);
        if (this.innerSteps > this.outerSteps) {
            return;
        }
        this.setSteps(this.outerSteps);
        List<Integer> sequence = EuclideanSequencer.cmdEuclideanRhythm(this.innerSteps, this.outerSteps);
        sequence = EuclideanSequencer.rotate(sequence, this.rotation);
        for (int i = 0; i < sequence.size(); ++i) {
            Integer step = sequence.get(i);
            MutableMonophonicSequencerStep mutableMonophonicSequencerStep = (MutableMonophonicSequencerStep)((WrappingPolyphonicSequencerStep)this.sequencerStep(i)).getForVoice(0);
            mutableMonophonicSequencerStep.setGate(step == 0 ? 0.0 : this.gate);
            mutableMonophonicSequencerStep.setNote(this.note);
        }
        if (wasActive) {
            this.setActive(true);
        }
    }

    private static List<Integer> rotate(List<Integer> sequence, int rotation) {
        for (int i = 0; i < sequence.size(); ++i) {
            if (sequence.get(i) != 1) continue;
            ArrayList<Integer> outputSequence = new ArrayList<Integer>();
            outputSequence.addAll(sequence.subList((i + rotation) % sequence.size(), sequence.size()));
            outputSequence.addAll(sequence.subList(0, (i + rotation) % sequence.size()));
            return outputSequence;
        }
        System.err.println("Couldn't find a single pulse in " + sequence);
        return sequence;
    }

    private static List<Integer> cmdEuclideanRhythm(int innerSteps, int outerSteps) {
        ArrayList<Integer> sequence = new ArrayList<Integer>();
        int bucket = 0;
        for (int i = 0; i < outerSteps; ++i) {
            if ((bucket += innerSteps) >= outerSteps) {
                bucket -= outerSteps;
                sequence.add(1);
                continue;
            }
            sequence.add(0);
        }
        return sequence;
    }

    private static MutableMonophonicSequencerStep[] sequence() {
        MutableMonophonicSequencerStep[] sequence = new MutableMonophonicSequencerStep[32];
        for (int i = 0; i < 32; ++i) {
            sequence[i] = new MutableMonophonicSequencerStep();
        }
        return sequence;
    }

    @Override
    protected void nextCycle() {
    }

    @Override
    protected void visualizeStep(int currentStep) {
    }

    @Override
    protected void visualizeBeat() {
        this.sequencerVisualizer.visualizedSequencerBeat(this);
    }

    public static void main(String[] args) {
        List<Integer> sequence = EuclideanSequencer.cmdEuclideanRhythm(6, 16);
        System.out.println(sequence);
        System.out.println(EuclideanSequencer.rotate(sequence, 0));
    }
}

