/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.arpeggiator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.input.AbstractMonophonicKeySequencer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.MonophonicSequencerStep;
import net.jevring.frequencies.v2.input.MutableMonophonicSequencerStep;
import net.jevring.frequencies.v2.input.WrappingPolyphonicSequencerStep;
import net.jevring.frequencies.v2.input.arpeggiator.Mode;
import net.jevring.frequencies.v2.input.midi.MidiNoteListener;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;

public class Arpeggiator
extends AbstractMonophonicKeySequencer<MutableMonophonicSequencerStep> {
    private final NavigableSet<Integer> keys = new ConcurrentSkipListSet<Integer>();
    private final MidiReceiver midiReceiver;
    private Mode mode = Mode.UP_AND_DOWN;
    private int octaves = 1;
    private double gate = 0.5;

    public Arpeggiator(MidiReceiver midiReceiver, Controls controls, KeyTimings keyTimings) {
        super((MonophonicSequencerStep[])Arpeggiator.sequence(), keyTimings, controls);
        this.midiReceiver = midiReceiver;
        controls.getBooleanControl("arpeggiator-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean active, Object source) {
                Arpeggiator.this.setActive(active);
            }
        });
        controls.getDiscreteControl("arpeggiator-mode").mapping(Mode::valueOf).addListener(new DiscreteControlListener<Mode>(){

            @Override
            public void valueChanged(Mode value, Object source) {
                Arpeggiator.this.mode = value;
                Arpeggiator.this.configureSequence();
            }
        });
        controls.getControl("arpeggiator-octaves").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double octaves, double max, Object source) {
                Arpeggiator.this.octaves = (int)octaves;
                Arpeggiator.this.configureSequence();
            }
        });
        controls.getControl("arpeggiator-gate").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double gate, double max, Object source) {
                Arpeggiator.this.gate = gate;
                Arpeggiator.this.configureSequence();
            }
        });
    }

    private static MutableMonophonicSequencerStep[] sequence() {
        MutableMonophonicSequencerStep[] sequence = new MutableMonophonicSequencerStep[256];
        for (int i = 0; i < 256; ++i) {
            sequence[i] = new MutableMonophonicSequencerStep();
        }
        return sequence;
    }

    private void configureSequence() {
        int steps = 0;
        if (this.mode == Mode.UP) {
            for (int octave = 0; octave < this.octaves; ++octave) {
                for (Integer key : this.keys) {
                    this.step(steps++, octave, key);
                }
            }
        } else if (this.mode == Mode.DOWN) {
            for (int octave = this.octaves; octave > 0; --octave) {
                Iterator<Integer> it = this.keys.descendingIterator();
                while (it.hasNext()) {
                    Integer key = it.next();
                    this.step(steps++, octave, key);
                }
            }
        } else if (this.mode == Mode.UP_AND_DOWN) {
            int octave;
            for (octave = 0; octave < this.octaves; ++octave) {
                for (Integer key : this.keys) {
                    this.step(steps++, octave, key);
                }
            }
            for (octave = this.octaves; octave > 0; --octave) {
                Iterator<Integer> it = this.keys.descendingIterator();
                while (it.hasNext()) {
                    Integer key;
                    key = it.next();
                    this.step(steps++, octave, key);
                }
            }
        } else if (this.mode == Mode.RANDOM) {
            steps = this.randomizeSteps();
        } else {
            System.err.println("Unknown arpeggiator mode " + this.mode);
            steps = 0;
        }
        this.setSteps(steps);
    }

    @Override
    protected void visualizeStep(int currentStep) {
    }

    @Override
    protected void visualizeBeat() {
        this.sequencerVisualizer.visualizedSequencerBeat(this);
    }

    private int randomizeSteps() {
        int steps = 0;
        ArrayList<Integer> randomKeys = new ArrayList<Integer>(this.keys);
        Collections.shuffle(randomKeys);
        for (int octave = 0; octave < this.octaves; ++octave) {
            for (Integer key : randomKeys) {
                this.step(steps++, octave, key);
            }
        }
        return steps;
    }

    private void step(int steps, int octave, Integer key) {
        MutableMonophonicSequencerStep arpeggiatorStep = (MutableMonophonicSequencerStep)((WrappingPolyphonicSequencerStep)this.sequencerStep(steps)).getForVoice(0);
        arpeggiatorStep.setGate(this.gate);
        arpeggiatorStep.setNote(key + octave * 12);
    }

    @Override
    protected void nextCycle() {
        if (this.mode == Mode.RANDOM) {
            this.randomizeSteps();
        }
    }

    @Override
    protected void setActive(boolean active) {
        this.keys.clear();
        super.setActive(active);
        if (active) {
            this.midiReceiver.listen(new MidiNoteListener(){

                @Override
                public void down(int key, int velocity) {
                    boolean immediateStart = Arpeggiator.this.keys.isEmpty();
                    Arpeggiator.this.keys.add(key);
                    Arpeggiator.this.configureSequence();
                    if (immediateStart) {
                        Arpeggiator.this.reset();
                    }
                }

                @Override
                public void up(int key) {
                    Arpeggiator.this.keys.remove(key);
                    Arpeggiator.this.configureSequence();
                }
            });
        } else {
            this.midiReceiver.stopListening();
        }
    }
}

