/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.wikipedia;

import net.jevring.frequencies.v2.filters.CutoffFrequencyFilter;

public class WikipediaRCHighPassFilter
implements CutoffFrequencyFilter {
    private static final double TWO_PI = Math.PI * 2;
    private final double dt;
    private volatile double cutoffFrequency;

    public WikipediaRCHighPassFilter(double sampleRate) {
        this.dt = 1.0 / sampleRate;
        this.setCutoffFrequency(sampleRate / 2.0);
    }

    @Override
    public double getCutoffFrequency() {
        return this.cutoffFrequency;
    }

    @Override
    public void setCutoffFrequency(double cutoffFrequency) {
        this.cutoffFrequency = cutoffFrequency;
    }

    @Override
    public double[] apply(double[] input) {
        double RC = 1.0 / (this.cutoffFrequency * (Math.PI * 2));
        double alpha = RC / (RC + this.dt);
        double[] output = new double[input.length];
        output[0] = input[0];
        for (int i = 1; i < input.length; ++i) {
            output[i] = alpha * (output[i - 1] + input[i] - input[i - 1]);
        }
        return output;
    }

    public String toString() {
        return "WikipediaRCHighPassFilter";
    }
}

