/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.open303;

import net.jevring.frequencies.v2.filters.AbstractFilter;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.open303.OnePoleFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class Open303TeeBeeFilter
extends AbstractFilter
implements ModulatedFilter {
    private static final double SQRT2 = 1.4142135623730951;
    private static final double ONE_OVER_SQRT2 = 0.7071067811865476;
    double b0;
    double a1;
    double y1;
    double y2;
    double y3;
    double y4;
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    double k;
    double g;
    double driveFactor;
    double drive;
    double resonanceRaw;
    double resonanceSkewed;
    double twoPiOverSampleRate;
    Mode mode;
    OnePoleFilter feedbackHighpass = new OnePoleFilter();

    public Open303TeeBeeFilter(double sampleRate) {
        super(sampleRate);
        this.setCutoffFrequency(1000.0);
        this.drive = 0.0;
        this.driveFactor = 1.0;
        this.resonanceRaw = 0.0;
        this.resonanceSkewed = 0.0;
        this.g = 1.0;
        this.twoPiOverSampleRate = Math.PI * 2 / sampleRate;
        this.feedbackHighpass.setMode(OnePoleFilter.Mode.HIGHPASS);
        this.feedbackHighpass.setCutoff(150.0);
        this.setMode(Mode.TB_303);
        this.calculateCoefficientsExact();
        this.reset();
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.getResonance();
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            this.setCutoffFrequency(initialCutoffFrequency + frequencyModulation[i] * 20000.0);
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[i], this.getMinResonance(), this.getMaxResonance()));
            output[i] = this.getSample(input[i]);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return output;
    }

    @Override
    public double[] apply(double[] input) {
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = this.getSample(input[i]);
        }
        return output;
    }

    private static double dB2amp(double dB) {
        return Math.exp(dB * 0.11512925464970228);
    }

    void setDrive(double newDrive) {
        this.drive = newDrive;
        this.driveFactor = Open303TeeBeeFilter.dB2amp(this.drive);
    }

    void setMode(Mode newMode) {
        this.mode = newMode;
        switch (this.mode) {
            case FLAT: {
                this.c0 = 1.0;
                this.c1 = 0.0;
                this.c2 = 0.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            case LP_6: {
                this.c0 = 0.0;
                this.c1 = 1.0;
                this.c2 = 0.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            case LP_12: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 1.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            case LP_18: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 0.0;
                this.c3 = 1.0;
                this.c4 = 0.0;
                break;
            }
            case LP_24: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 0.0;
                this.c3 = 0.0;
                this.c4 = 1.0;
                break;
            }
            case HP_6: {
                this.c0 = 1.0;
                this.c1 = -1.0;
                this.c2 = 0.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            case HP_12: {
                this.c0 = 1.0;
                this.c1 = -2.0;
                this.c2 = 1.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            case HP_18: {
                this.c0 = 1.0;
                this.c1 = -3.0;
                this.c2 = 3.0;
                this.c3 = -1.0;
                this.c4 = 0.0;
                break;
            }
            case HP_24: {
                this.c0 = 1.0;
                this.c1 = -4.0;
                this.c2 = 6.0;
                this.c3 = -4.0;
                this.c4 = 1.0;
                break;
            }
            case BP_12_12: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 1.0;
                this.c3 = -2.0;
                this.c4 = 1.0;
                break;
            }
            case BP_6_18: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 0.0;
                this.c3 = 1.0;
                this.c4 = -1.0;
                break;
            }
            case BP_18_6: {
                this.c0 = 0.0;
                this.c1 = 1.0;
                this.c2 = -3.0;
                this.c3 = 3.0;
                this.c4 = -1.0;
                break;
            }
            case BP_6_12: {
                this.c0 = 0.0;
                this.c1 = 0.0;
                this.c2 = 1.0;
                this.c3 = -1.0;
                this.c4 = 0.0;
                break;
            }
            case BP_12_6: {
                this.c0 = 0.0;
                this.c1 = 1.0;
                this.c2 = -2.0;
                this.c3 = 1.0;
                this.c4 = 0.0;
                break;
            }
            case BP_6_6: {
                this.c0 = 0.0;
                this.c1 = 1.0;
                this.c2 = -1.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
                break;
            }
            default: {
                this.c0 = 1.0;
                this.c1 = 0.0;
                this.c2 = 0.0;
                this.c3 = 0.0;
                this.c4 = 0.0;
            }
        }
        this.calculateCoefficientsApprox4();
    }

    @Override
    public void reset() {
        this.feedbackHighpass.reset();
        this.y1 = 0.0;
        this.y2 = 0.0;
        this.y3 = 0.0;
        this.y4 = 0.0;
    }

    @Override
    public void setCutoffFrequency(double cutoffFrequency) {
        super.setCutoffFrequency(Clamp.clamp(cutoffFrequency, 200.0, 20000.0));
        this.calculateCoefficientsApprox4();
    }

    @Override
    public double getResonance() {
        return 100.0 * this.resonanceRaw;
    }

    @Override
    public void setResonance(double newResonance) {
        this.resonanceRaw = 0.01 * newResonance;
        this.resonanceSkewed = (1.0 - Math.exp(-3.0 * this.resonanceRaw)) / (1.0 - Math.exp(-3.0));
        this.calculateCoefficientsApprox4();
    }

    @Override
    public double getMaxResonance() {
        return 100.0;
    }

    void calculateCoefficientsExact() {
        double wc = this.twoPiOverSampleRate * this.cutoffFrequency;
        double s = Math.sin(wc);
        double c = Math.cos(wc);
        double t = Math.tan(0.25 * (wc - Math.PI));
        double r = this.resonanceSkewed;
        double a1_fullRes = t / (s - c * t);
        double x = Math.exp(-wc);
        double a1_noRes = -x;
        this.a1 = r * a1_fullRes + (1.0 - r) * a1_noRes;
        this.b0 = 1.0 + this.a1;
        double gsq = this.b0 * this.b0 / (1.0 + this.a1 * this.a1 + 2.0 * this.a1 * c);
        this.k = r / (gsq * gsq);
        if (this.mode == Mode.TB_303) {
            this.k *= 4.25;
        }
    }

    void calculateCoefficientsApprox4() {
        double wc = this.twoPiOverSampleRate * this.cutoffFrequency;
        double wc2 = wc * wc;
        double r = this.resonanceSkewed;
        double pa12 = -0.01341281325101042;
        double pa11 = 0.08168739417977708;
        double pa10 = -0.2365036766021623;
        double pa09 = 0.4439739664918068;
        double pa08 = -0.6297350825423579;
        double pa07 = 0.752969164867889;
        double pa06 = -0.8249882473764324;
        double pa05 = 0.8736418933533319;
        double pa04 = -0.9164580250284832;
        double pa03 = 0.9583192455599817;
        double pa02 = -0.9999994950291231;
        double pa01 = 0.9999999927726119;
        double pa00 = -0.9999999999857464;
        double tmp = wc2 * pa12 + pa11 * wc + pa10;
        tmp = wc2 * tmp + pa09 * wc + pa08;
        tmp = wc2 * tmp + pa07 * wc + pa06;
        tmp = wc2 * tmp + pa05 * wc + pa04;
        tmp = wc2 * tmp + pa03 * wc + pa02;
        this.a1 = wc2 * tmp + pa01 * wc + pa00;
        this.b0 = 1.0 + this.a1;
        double pr8 = -4.554677015609929E-5;
        double pr7 = -2.022131730719448E-5;
        double pr6 = 0.002784706718370008;
        double pr5 = 0.00207992115173378;
        double pr4 = -0.08333236384240325;
        double pr3 = -0.1666668203490468;
        double pr2 = 1.00000001212423;
        double pr1 = 3.99999999965004;
        double pr0 = 4.000000000000113;
        tmp = wc2 * pr8 + pr7 * wc + pr6;
        tmp = wc2 * tmp + pr5 * wc + pr4;
        tmp = wc2 * tmp + pr3 * wc + pr2;
        tmp = wc2 * tmp + pr1 * wc + pr0;
        this.k = r * tmp;
        this.g = 1.0;
        if (this.mode == Mode.TB_303) {
            double fx = wc * 0.7071067811865476 / (Math.PI * 2);
            this.b0 = (4.5522346E-4 + 6.1922189 * fx) / (1.0 + 12.358354 * fx + 4.4156345 * (fx * fx));
            this.k = fx * (fx * (fx * (fx * (fx * (fx + 7198.6997) - 5837.7917) - 476.47308) + 614.95611) + 213.87126) + 16.998792;
            this.g = this.k * 0.058823529411764705;
            this.g = (this.g - 1.0) * r + 1.0;
            this.g *= 1.0 + r;
            this.k *= r;
        }
    }

    double shape(double x) {
        double r6 = 0.16666666666666666;
        x = Clamp.clamp(x, -1.4142135623730951, 1.4142135623730951);
        return x - r6 * x * x * x;
    }

    double getSample(double in) {
        if (this.mode == Mode.TB_303) {
            double y0 = in - this.feedbackHighpass.getSample(this.k * this.y4);
            this.y1 += 2.0 * this.b0 * (y0 - this.y1 + this.y2);
            this.y2 += this.b0 * (this.y1 - 2.0 * this.y2 + this.y3);
            this.y3 += this.b0 * (this.y2 - 2.0 * this.y3 + this.y4);
            this.y4 += this.b0 * (this.y3 - 2.0 * this.y4);
            return 2.0 * this.g * this.y4;
        }
        double y0 = 0.125 * this.driveFactor * in - this.feedbackHighpass.getSample(this.k * this.y4);
        this.y1 = y0 + this.a1 * (y0 - this.y1);
        this.y2 = this.y1 + this.a1 * (this.y1 - this.y2);
        this.y3 = this.y2 + this.a1 * (this.y2 - this.y3);
        this.y4 = this.y3 + this.a1 * (this.y3 - this.y4);
        return 8.0 * (this.c0 * y0 + this.c1 * this.y1 + this.c2 * this.y2 + this.c3 * this.y3 + this.c4 * this.y4);
    }

    static enum Mode {
        FLAT,
        LP_6,
        LP_12,
        LP_18,
        LP_24,
        HP_6,
        HP_12,
        HP_18,
        HP_24,
        BP_12_12,
        BP_6_18,
        BP_18_6,
        BP_6_12,
        BP_12_6,
        BP_6_6,
        TB_303;

    }
}

