/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.open303;

public class OnePoleFilter {
    double x1;
    double y1;
    double b0;
    double b1;
    double a1;
    double cutoff;
    double shelvingGain;
    Mode mode = Mode.BYPASS;
    double sampleRate;
    double sampleRateRec;

    public OnePoleFilter() {
        this.setShelvingGain(1.0);
        this.setSampleRate(44100.0);
        this.setMode(Mode.BYPASS);
        this.setCutoff(20000.0);
        this.reset();
    }

    void setSampleRate(double newSampleRate) {
        if (newSampleRate > 0.0) {
            this.sampleRate = newSampleRate;
        }
        this.sampleRateRec = 1.0 / this.sampleRate;
        this.calcCoeffs();
    }

    void setMode(Mode newMode) {
        this.mode = newMode;
        this.calcCoeffs();
    }

    void setCutoff(double newCutoff) {
        this.cutoff = newCutoff > 0.0 && newCutoff <= 20000.0 ? newCutoff : 20000.0;
        this.calcCoeffs();
    }

    void setShelvingGain(double newGain) {
        if (newGain > 0.0) {
            this.shelvingGain = newGain;
            this.calcCoeffs();
        }
    }

    void setShelvingGainInDecibels(double newGain) {
        this.setShelvingGain(OnePoleFilter.dB2amp(newGain));
    }

    void setCoefficients(double newB0, double newB1, double newA1) {
        this.b0 = newB0;
        this.b1 = newB1;
        this.a1 = newA1;
    }

    void setInternalState(double newX1, double newY1) {
        this.x1 = newX1;
        this.y1 = newY1;
    }

    void calcCoeffs() {
        switch (this.mode) {
            case LOWPASS: {
                double x = Math.exp(Math.PI * -2 * this.cutoff * this.sampleRateRec);
                this.b0 = 1.0 - x;
                this.b1 = 0.0;
                this.a1 = x;
                break;
            }
            case HIGHPASS: {
                double x = Math.exp(Math.PI * -2 * this.cutoff * this.sampleRateRec);
                this.b0 = 0.5 * (1.0 + x);
                this.b1 = -0.5 * (1.0 + x);
                this.a1 = x;
                break;
            }
            case LOWSHELV: {
                double c = 0.5 * (this.shelvingGain - 1.0);
                double t = Math.tan(Math.PI * this.cutoff * this.sampleRateRec);
                double a = this.shelvingGain >= 1.0 ? (t - 1.0) / (t + 1.0) : (t - this.shelvingGain) / (t + this.shelvingGain);
                this.b0 = 1.0 + c + c * a;
                this.b1 = c + c * a + a;
                this.a1 = -a;
                break;
            }
            case HIGHSHELV: {
                double c = 0.5 * (this.shelvingGain - 1.0);
                double t = Math.tan(Math.PI * this.cutoff * this.sampleRateRec);
                double a = this.shelvingGain >= 1.0 ? (t - 1.0) / (t + 1.0) : (this.shelvingGain * t - 1.0) / (this.shelvingGain * t + 1.0);
                this.b0 = 1.0 + c - c * a;
                this.b1 = a + c * a - c;
                this.a1 = -a;
                break;
            }
            case ALLPASS: {
                double x;
                double t = Math.tan(Math.PI * this.cutoff * this.sampleRateRec);
                this.b0 = x = (t - 1.0) / (t + 1.0);
                this.b1 = 1.0;
                this.a1 = -x;
                break;
            }
            default: {
                this.b0 = 1.0;
                this.b1 = 0.0;
                this.a1 = 0.0;
            }
        }
    }

    void reset() {
        this.x1 = 0.0;
        this.y1 = 0.0;
    }

    private static double dB2amp(double dB) {
        return Math.exp(dB * 0.11512925464970228);
    }

    double getSample(double in) {
        this.y1 = this.b0 * in + this.b1 * this.x1 + this.a1 * this.y1 + Double.MIN_VALUE;
        this.x1 = in;
        return this.y1;
    }

    static enum Mode {
        BYPASS,
        LOWPASS,
        HIGHPASS,
        LOWSHELV,
        HIGHSHELV,
        ALLPASS;

    }
}

