/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class Simplified4PoleLadderFilter
extends AbstractLadderFilter
implements ModulatedFilter {
    private double output;
    private double lastStage;
    private double[] stage = new double[4];
    private double[] stageZ1 = new double[4];
    private double[] stageTanh = new double[3];
    private double h;
    private double h0;
    private double g;
    double gainCompensation = 0.5;

    public Simplified4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = Math.min(c, this.sampleRate / 10.0);
        double fs2 = this.sampleRate;
        this.g = Math.PI * 2 * this.cutoffFrequency / fs2;
        this.g *= 2.41660973353061;
        this.h = this.g / 1.3;
        this.h0 = this.g * 0.3 / 1.3;
    }

    @Override
    public double getMaxResonance() {
        return 10.0;
    }

    @Override
    public void reset() {
        Arrays.fill(this.stage, 0.0);
        Arrays.fill(this.stageZ1, 0.0);
        Arrays.fill(this.stageTanh, 0.0);
        this.output = 0.0;
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.resonance;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.setCutoffFrequency(Clamp.clamp(initialCutoffFrequency + frequencyModulation[s] * 20000.0, 20.0, 20000.0));
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance()));
            this.loop(samples, s);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.loop(samples, s);
        }
        return samples;
    }

    private void loop(double[] samples, int s) {
        for (int stageIdx = 0; stageIdx < 4; ++stageIdx) {
            if (stageIdx != 0) {
                in = this.stage[stageIdx - 1];
                this.stageTanh[stageIdx - 1] = Math.tanh(in);
                this.stage[stageIdx] = this.h * this.stageZ1[stageIdx] + this.h0 * this.stageTanh[stageIdx - 1] + (1.0 - this.g) * (stageIdx != 3 ? this.stageTanh[stageIdx] : Math.tanh(this.stageZ1[stageIdx]));
            } else {
                in = samples[s] - 4.0 * this.resonance * (this.output - this.gainCompensation * samples[s]);
                this.stage[stageIdx] = this.h * Math.tanh(in) + this.h0 * this.stageZ1[stageIdx] + (1.0 - this.g) * this.stageTanh[stageIdx];
            }
            this.stageZ1[stageIdx] = this.stage[stageIdx];
        }
        this.output = this.stage[3];
        samples[s] = this.output = this.snapToZero(this.output);
    }
}

