/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class Oberheim4PoleLadderFilter
extends AbstractLadderFilter
implements ModulatedFilter {
    private final VAOnePole lpf1;
    private final VAOnePole lpf2;
    private final VAOnePole lpf3;
    private final VAOnePole lpf4;
    private double K;
    private double gamma;
    private double alpha0;
    private double Q = 3.0;
    private double saturation = 1.0;
    private double[] oberheimCoefs = new double[5];

    public Oberheim4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
        this.lpf1 = new VAOnePole();
        this.lpf2 = new VAOnePole();
        this.lpf3 = new VAOnePole();
        this.lpf4 = new VAOnePole();
    }

    @Override
    public void reset() {
        this.lpf1.reset();
        this.lpf2.reset();
        this.lpf3.reset();
        this.lpf4.reset();
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.resonance;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.setCutoffFrequency(Clamp.clamp(initialCutoffFrequency + frequencyModulation[s] * 20000.0, 20.0, 20000.0));
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance()));
            this.loop(samples, s);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.loop(samples, s);
        }
        return samples;
    }

    private void loop(double[] samples, int s) {
        double in = samples[s];
        double sigma = this.lpf1.getFeedbackOutput() + this.lpf2.getFeedbackOutput() + this.lpf3.getFeedbackOutput() + this.lpf4.getFeedbackOutput();
        double u = ((in *= 1.0 + this.K) - this.K * sigma) * this.alpha0;
        u = Math.tanh(this.saturation * u);
        double stage1 = this.lpf1.tick(u);
        double stage2 = this.lpf2.tick(stage1);
        double stage3 = this.lpf3.tick(stage2);
        double stage4 = this.lpf4.tick(stage3);
        samples[s] = this.oberheimCoefs[0] * u + this.oberheimCoefs[1] * stage1 + this.oberheimCoefs[2] * stage2 + this.oberheimCoefs[3] * stage3 + this.oberheimCoefs[4] * stage4;
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = c;
        double wd = Math.PI * 2 * this.cutoffFrequency;
        double T = 1.0 / this.sampleRate;
        double wa = 2.0 / T * Math.tan(wd * T / 2.0);
        double g = wa * T / 2.0;
        double G = g / (1.0 + g);
        this.lpf1.setAlpha(G);
        this.lpf2.setAlpha(G);
        this.lpf3.setAlpha(G);
        this.lpf4.setAlpha(G);
        this.lpf1.setBeta(G * G * G / (1.0 + g));
        this.lpf2.setBeta(G * G / (1.0 + g));
        this.lpf3.setBeta(G / (1.0 + g));
        this.lpf4.setBeta(1.0 / (1.0 + g));
        this.gamma = G * G * G * G;
        this.alpha0 = 1.0 / (1.0 + this.K * this.gamma);
        this.oberheimCoefs[0] = 0.0;
        this.oberheimCoefs[1] = 0.0;
        this.oberheimCoefs[2] = 0.0;
        this.oberheimCoefs[3] = 0.0;
        this.oberheimCoefs[4] = 1.0;
    }

    @Override
    public void setResonance(double r) {
        this.K = 4.0 * (r - 1.0) / 9.0;
    }

    @Override
    public double getMaxResonance() {
        return 10.0;
    }

    @Override
    public double getMinResonance() {
        return 1.0;
    }

    private static final class VAOnePole {
        private double alpha;
        private double beta;
        private double gamma;
        private double delta;
        private double epsilon;
        private double a0;
        private double feedback;
        private double z1;

        private VAOnePole() {
            this.reset();
        }

        void reset() {
            this.alpha = 1.0;
            this.beta = 0.0;
            this.gamma = 1.0;
            this.delta = 0.0;
            this.epsilon = 0.0;
            this.a0 = 1.0;
            this.feedback = 0.0;
            this.z1 = 0.0;
        }

        double tick(double s) {
            s = s * this.gamma + this.feedback + this.epsilon * this.getFeedbackOutput();
            double vn = (this.a0 * s - this.z1) * this.alpha;
            double out = vn + this.z1;
            this.z1 = vn + out;
            return out;
        }

        double getFeedbackOutput() {
            return this.beta * (this.z1 + this.feedback * this.delta);
        }

        void setAlpha(double a) {
            this.alpha = a;
        }

        void setBeta(double b) {
            this.beta = b;
        }
    }
}

