/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;

public class MusicDSP4PoleLadderFilter
extends AbstractLadderFilter {
    private double p;
    private double k;
    private double t1;
    private double t2;
    private double[] delay = new double[4];
    private double[] stage = new double[4];

    public MusicDSP4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
        this.setCutoffFrequency(1000.0);
        this.setResonance(0.1);
    }

    @Override
    public void reset() {
        Arrays.fill(this.delay, 0.0);
        Arrays.fill(this.stage, 0.0);
    }

    @Override
    public void setResonance(double r) {
        this.resonance = r * (this.t2 + 6.0 * this.t1) / (this.t2 - 6.0 * this.t1);
    }

    @Override
    public double getMaxResonance() {
        return 20.0;
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = 2.0 * c / this.sampleRate;
        this.p = this.cutoffFrequency * (1.8 - 0.8 * this.cutoffFrequency);
        this.k = 2.0 * Math.sin(this.cutoffFrequency * Math.PI * 0.5) - 1.0;
        this.t1 = (1.0 - this.p) * 1.386249;
        this.t2 = 12.0 + this.t1 * this.t1;
        this.setResonance(this.resonance);
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            double x = samples[s] - this.resonance * this.stage[3];
            this.stage[0] = x * this.p + this.delay[0] * this.p - this.k * this.stage[0];
            this.stage[1] = this.stage[0] * this.p + this.delay[1] * this.p - this.k * this.stage[1];
            this.stage[2] = this.stage[1] * this.p + this.delay[2] * this.p - this.k * this.stage[2];
            this.stage[3] = this.stage[2] * this.p + this.delay[3] * this.p - this.k * this.stage[3];
            this.stage[3] = this.stage[3] - this.stage[3] * this.stage[3] * this.stage[3] / 6.0;
            this.delay[0] = x;
            this.delay[1] = this.stage[0];
            this.delay[2] = this.stage[1];
            this.delay[3] = this.stage[2];
            samples[s] = this.stage[3];
        }
        return samples;
    }
}

