/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;

public class DAngeloValimaki4PoleLadderFilter
extends AbstractLadderFilter {
    private static final double VT = 0.312;
    private double[] V = new double[4];
    private double[] dV = new double[4];
    private double[] tV = new double[4];
    private double g;
    private double drive = 1.0;

    public DAngeloValimaki4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
        this.setCutoffFrequency(1000.0);
        this.setResonance(0.1);
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = c;
        double x = Math.PI * this.cutoffFrequency / this.sampleRate;
        this.g = 3.9207076316800618 * this.cutoffFrequency * (1.0 - x) / (1.0 + x);
    }

    @Override
    public double getMaxResonance() {
        return 20.0;
    }

    @Override
    public void reset() {
        Arrays.fill(this.V, 0.0);
        Arrays.fill(this.dV, 0.0);
        Arrays.fill(this.tV, 0.0);
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int i = 0; i < input.length; ++i) {
            double dV0 = -this.g * (Math.tanh((this.drive * samples[i] + this.resonance * this.V[3]) / 0.624) + this.tV[0]);
            this.V[0] = this.V[0] + (dV0 + this.dV[0]) / (2.0 * this.sampleRate);
            this.dV[0] = dV0;
            this.tV[0] = Math.tanh(this.V[0] / 0.624);
            double dV1 = this.g * (this.tV[0] - this.tV[1]);
            this.V[1] = this.V[1] + (dV1 + this.dV[1]) / (2.0 * this.sampleRate);
            this.dV[1] = dV1;
            this.tV[1] = Math.tanh(this.V[1] / 0.624);
            double dV2 = this.g * (this.tV[1] - this.tV[2]);
            this.V[2] = this.V[2] + (dV2 + this.dV[2]) / (2.0 * this.sampleRate);
            this.dV[2] = dV2;
            this.tV[2] = Math.tanh(this.V[2] / 0.624);
            double dV3 = this.g * (this.tV[2] - this.tV[3]);
            this.V[3] = this.V[3] + (dV3 + this.dV[3]) / (2.0 * this.sampleRate);
            this.dV[3] = dV3;
            this.tV[3] = Math.tanh(this.V[3] / 0.624);
            samples[i] = this.V[3];
        }
        return samples;
    }
}

